using System;
using System.Collections;
using System.Reflection;
using System.Drawing;

using Microsoft.DirectX.Direct3D;
using Microsoft.DirectX;
using Microsoft.DirectX.DirectInput;

using DarkStrideToolbox; 


namespace DarkStride.StellarLanes.SharedDLL
{
	public class Session
	{
        private bool m_bHaveReceivedSession = false;
        private System.Collections.Generic.List<Zone> m_oaZones = new System.Collections.Generic.List<Zone>();
		#region Member Variables
        #region Constants
        private const double m_cCHASSIS_REDFLASH_TIME = 2.0;
        private const int m_cEDITOR_PAGE_WIDTH = 50;
        private const double m_cDEFAULT_ZOOM = .5;

        public const int m_cEDITOR_GRID_WIDTH_MODULE = 6;
        public const int m_cEDITOR_GRID_WIDTH_CHASSIS = 12;

        //Wave through which this type of item is generated
        private const long m_cWAVE_NORMAL = 2;
        private const long m_cWAVE_ADVANCED = 4;

        private const int m_cNUMBEROFTABS = 2;
        #endregion
        
		//Profile stuff
		private double m_nTimeSinceLastProfileSave = 0;

		//Menu paramaters
		private bool m_bMenuIsOpen = false;
		private int m_nMenuTop = 0;

		private RenderSettings m_oLastRenderSettingsUsed = null;

		public DateTime m_dtLastServerProcess = DateTime.MinValue;

        //Editor fields
		private Chassis m_oDraggingChassis = null;
		private Module m_oDraggingModule = null;
		private ArrayList m_oaDraggingModulePlacableLocs = null;
		private System.Threading.Thread m_oDraggingModulePlacableLocsCalculation = null;
		private Skin m_oDraggingSkin = null;
		private int m_nDraggingStartX = 0;
		private int m_nDraggingStartY = 0;

		private enumGameScreen m_nCurrentScreen = enumGameScreen.InSpace;
		private enumEditorObject m_nCurrentInEditorDisplay = enumEditorObject.Chassis;
        private double m_nCurrentZoom = m_cDEFAULT_ZOOM;

        //Game management
        private Zones m_oZones = new Zones();
		private string m_sSessionName = "";
        private string m_sGUID = "";
        //private EntitysByZone m_oEntitysByZone = new EntitysByZone();
        //private EntitysByZone m_oSuperMassEntitys = new EntitysByZone();
		private DSSortedList m_oNetworkPlayers = new DSSortedList();
		private DSSortedList m_oRemovedEntitys = new DSSortedList();
        private Entitys m_oEntitiesNeedingToBeSent_Full = new Entitys();
        private Entitys m_oEntitiesNeedingToBeSent_Lite = new Entitys();

		private System.Drawing.Rectangle m_oAreaToDrawAt = System.Drawing.Rectangle.Empty;
		private Entity m_oEntityCenteredOn = null;
		private Vector2 m_vEntityOffset = Vector2.Empty;
		private double m_nZoomLevel = 0;

		private bool m_bDebug_Debug = false;
		private bool m_bDebug_FPS = false;
		private bool m_bDebug_Collide = false;
		private bool m_bDebug_NoAI = false;
		private bool m_bDebug_Locs = false;
		private bool m_bDebug_Pause = false;

		private AlertManager m_oAlertManager = null;
		private bool m_bTyping = false;
		private string m_sTypingText = "";

		//Hover functionality in editor
		private double m_nAppTimeOfLastMouseMove = 0;
		private bool m_bHaveStartedHovering = false;
		private object m_oCurrentMouseHoverPart = null;
		private Vector2 m_vMouseHoverPoint = Vector2.Empty;

		//Rolling text storage
		private ArrayList m_oRollingTexts = new ArrayList();

		private int m_nChassisPage = 0;
		private int m_nModulePage = 0;
		private int m_nSkinPage = 0;

		private Starscape m_oStarscape = null;
		//private WaveManager m_oWaveManager = null;

		//This handles the chassis turning red from a failed removal click
		private DSSortedList m_oRedChasses = new DSSortedList();
		#endregion
		#region Events
		public event EventHandler LaunchResumeMenu;
		#endregion


		public Session()
        {
			m_sGUID = DSMisc.GetGUID();

			if( Globals.Inst().IAmTheServer == false )
			{
				m_oAlertManager = new AlertManager( Globals.Inst().GameEngine );
				m_oStarscape = new Starscape( Globals.Inst().GameEngine );
            }
            else
            {
                SpawnNewUniverse();
            }

            //m_oWaveManager = new WaveManager();
		}

		#region Advance & Rendering
		//Advancing Stuff
		public void Advance( double nElapsedTime )
		{
			Entity oLoopEntity = null;


			try
			{
				//m_oWaveManager.Advance( this,nElapsedTime );

				//Starscape move stuff
				Vector2 vPosOfOurShipAtBeginning = Vector2.Empty;
				if( Globals.Inst().OurShip != null )
				{
					vPosOfOurShipAtBeginning = Globals.Inst().OurShip.Pos;
				}

				#region Editor Mouse Hover Functionality
				//Check the mouse hover stuff
				if( Globals.Inst().IAmTheServer == false &&
					m_nCurrentInEditorDisplay != enumEditorObject.Skins &&
					m_nCurrentScreen == enumGameScreen.Editor &&
					m_bHaveStartedHovering == false && m_oCurrentMouseHoverPart != null && 
					m_oDraggingChassis == null && m_oDraggingModule == null && m_oDraggingSkin == null &&
					Globals.Inst().GameEngine.AppTime - m_nAppTimeOfLastMouseMove > .4 )
				{
					m_bHaveStartedHovering = true;

					if( Globals.ObjectIsModule( m_oCurrentMouseHoverPart ) == true )
					{
						((Module)m_oCurrentMouseHoverPart).HoverStart();
					}
					else if( Globals.ObjectIsChassis( m_oCurrentMouseHoverPart ) == true )
					{
						((Chassis)m_oCurrentMouseHoverPart).HoverStart();
					}			
				}
				#endregion

				if( Globals.Inst().IAmTheServer == false )
				{
					m_oAreaToDrawAt = new System.Drawing.Rectangle( 
						0,0,
						Globals.Inst().GameEngine.ScreenWidth,
						Globals.Inst().GameEngine.ScreenHeight );
					m_oEntityCenteredOn = Globals.Inst().OurShip;
					m_vEntityOffset = new Vector2( 0,0 );
					m_nZoomLevel = 1;
				}


				//Update our zoom level 
				UpdateOurZoomLevel( nElapsedTime );


				//Update all our removed entitys
				for( int nRemovedIdx=0 ; nRemovedIdx<m_oRemovedEntitys.Count-1 ; nRemovedIdx++ )
				{
					if( nRemovedIdx >= m_oRemovedEntitys.Count ){ break; }
					oLoopEntity = (Entity)m_oRemovedEntitys.GetByIndex( nRemovedIdx );

					oLoopEntity.TotalElapsedTime += nElapsedTime;
					if( oLoopEntity.TotalElapsedTime > 60 && oLoopEntity.OwnerSocketID == MiscConstants.m_cNOSOCKETIDASSIGNED )
					{
						m_oRemovedEntitys.RemoveAt( nRemovedIdx );
						nRemovedIdx--;
					}
                }


                //Advance our zones
                m_oZones.Advance( this, nElapsedTime );


                #region Unused super mass entity update for gravity
                /*//Update all our entitys
				lock( m_oEntitys )
				{
					oTempEntitys = m_oEntitys.Clone();
				}
				lock( m_oSuperMassEntitys )
				{
					oTempSuperMassEntitys = m_oSuperMassEntitys.Clone();
				}				
				//Go through all the entitys, they won't be changing.  And resolve planitary bleed...
				for( int nPlanetIndex=0 ; nPlanetIndex<oTempEntitys.Count ; nPlanetIndex++ )
				{
					oLoopPlanet = (Entity)oTempEntitys.GetByIndex( nPlanetIndex );
					for( int nEntityIndex=0 ; nEntityIndex<oTempEntitys.Count ; nEntityIndex++ )
					{
						oLoopEntity = (Entity)oTempEntitys.GetByIndex( nEntityIndex );

						if( oLoopEntity.PKey != oLoopPlanet.PKey )
						{
							ResolveGravityBleeding( oLoopEntity,oLoopPlanet );
						}
					}
				}*/
                #endregion



                TransmitEntitysNeedingToBeTransmitted_ServerOnly();

                if ( m_oAlertManager != null )
				{
					m_oAlertManager.Advance( nElapsedTime );
				}

				//Advance our starscape
				if( vPosOfOurShipAtBeginning != Vector2.Empty )
				{
					m_oStarscape.AdvanceStarScape( m_nCurrentZoom,Globals.Inst().OurShip.Pos - vPosOfOurShipAtBeginning );
				}
				AdvanceRollingText( nElapsedTime );


				//Advance our menu movement;
				if( m_bMenuIsOpen == true && m_nMenuTop < GraphicConstants.m_cINGAME_MENUMAXRISE )
				{
					m_nMenuTop += (int)( nElapsedTime * 1000 );
				}
				else if( m_bMenuIsOpen == false && m_nMenuTop > 0 )
				{
					m_nMenuTop -= (int)( nElapsedTime * 1000 );
				}

				//Advance our profile saving
				m_nTimeSinceLastProfileSave += nElapsedTime;
				if( Globals.Inst().IAmTheServer == false && 
					m_nTimeSinceLastProfileSave > 4*60 && Globals.Inst().Profile.IsDirty == true )
				{
					//AddChatMsg( Globals.Inst().GameEngine.DirectPlay.Me,"Saving character file..." );

					m_nTimeSinceLastProfileSave = 0;
					Globals.Inst().Profile.SaveToFile( false );
                }
            }
			catch( System.Exception oEx )
			{
				DSMisc.ShowErrors( oEx );
			}
		}
		private void TransmitEntitysNeedingToBeTransmitted_ServerOnly()
		{
			DSNetworkPacket oPacket = null;


			
			//Anyone that especially needs to be sent out?
			foreach( Entity oLoopEntity in m_oEntitiesNeedingToBeSent_Full.Values )
			{
                if( Globals.Inst().IAmTheServer == false )
                {
				    NetMsg.Send_EntityUpdate( Globals.Inst().Network,Globals.Inst().Network.PlayerWhoIsHost, this, oLoopEntity);
                }
                else
                {
                    oPacket = NetMsg.Pckt_EntityUpdate( this,oLoopEntity );
					SendMsgOnToAllPlayersInSession( oPacket );
                }
				oLoopEntity.TimeSinceLastLiteSend = 0;
			}
            m_oEntitiesNeedingToBeSent_Full.Clear();

			
			//Send a full update from time to time
			if( Globals.Inst().OurShip != null && Globals.Inst().OurShip.TimeSinceLastLiteSend > .1 ) 
			{
                TransmitEntity(Globals.Inst().OurShip, false);
			}

			foreach( Entity oLoopEntity in m_oEntitiesNeedingToBeSent_Lite.Values )
			{
                if( Globals.Inst().IAmTheServer == false )
                {
				    NetMsg.Send_EntityLiteUpdate( Globals.Inst().Network,Globals.Inst().Network.PlayerWhoIsHost,oLoopEntity );
                }
                else
                {
                    oPacket = NetMsg.Pckt_EntityLiteUpdate( oLoopEntity );
					SendMsgOnToAllPlayersInSession( oPacket );
                }
				oLoopEntity.TimeSinceLastLiteSend = 0;
			}
            m_oEntitiesNeedingToBeSent_Lite.Clear();
		}
		private void AdvanceRollingText( double nElapsedTime )
		{
			RollingText oLoopText = null;
			double nAppTime = Globals.Inst().GameEngine.AppTime;


			for( int i=0 ; i<m_oRollingTexts.Count ; i++ )
			{
				if( i >= m_oRollingTexts.Count ){ break; }
				oLoopText = (RollingText)m_oRollingTexts[ i ];

				//To old, remove it please
				if( nAppTime - oLoopText.AppTimeTextStarted > 3 )
				{
					m_oRollingTexts.RemoveAt( i );
					i--;
				}
				//Advance it
				else
				{
					oLoopText.Pos = new Vector2( (float)( oLoopText.Pos.X + nElapsedTime * 10.0f + oLoopText.Vel.X * nElapsedTime ),
												 (float)( oLoopText.Pos.Y + nElapsedTime * 60.0f + oLoopText.Vel.Y * nElapsedTime ) );
				}
			}
		}
        
		//Rendering Stuff
		public void Render2DAfterForms()
		{
			Vector2 vWorldUpperLeftCorner = Vector2.Empty;
			Vector2 vScreenUpperLeftCorner = Vector2.Empty;
			Vector2 vScreenLowerRightCorner = Vector2.Empty;
			Vector2 vWorldGridUpperLeftCorner = Vector2.Empty;
			Vector2 vScreenGridUpperLeftCorner = Vector2.Empty;
			System.Drawing.Point oConnector = System.Drawing.Point.Empty;
			System.Drawing.Point oConflict = System.Drawing.Point.Empty;
			System.Drawing.Point oPlacableLoc = System.Drawing.Point.Empty;
			System.Drawing.Color oColor = System.Drawing.Color.White;
			double nPerc = 0;
			double nMaxShield = 0;
			string sTexture = "";
			int nShieldLevel = 0;
			LoadedTexture oTex = null;
			System.Drawing.Rectangle oR = System.Drawing.Rectangle.Empty;
			System.Drawing.Rectangle oTargetRect = System.Drawing.Rectangle.Empty;
			System.Drawing.Rectangle oGridArea = System.Drawing.Rectangle.Empty;
			System.Drawing.Rectangle oButtonRect = System.Drawing.Rectangle.Empty;
			System.Drawing.Rectangle oTextRect = System.Drawing.Rectangle.Empty;
			System.Drawing.Rectangle oClipping = System.Drawing.Rectangle.Empty;
			enumRenderType[] oaRenderModes = null;
			RenderSettings oRenderSettings = null;
            Zone oMyZone = null;
            string sMsg = string.Empty;
            Microsoft.DirectX.Direct3D.Font oFont = null;


			try
			{
                //Find my ships zone
                oMyZone = Globals.Inst().MyZone;

				#region Always render our starscape!
				//Find out what the valid bounds for the screen are
				oRenderSettings = new RenderSettings( m_oAreaToDrawAt,Globals.Inst().OurShip,
													  new Vector2(0,0),m_nCurrentZoom,enumRenderType.HUD,
													  m_nCurrentInEditorDisplay,m_nCurrentScreen,
													  0,System.Drawing.Color.White );
                m_oLastRenderSettingsUsed = new RenderSettings(oRenderSettings);
				//Find the upper left hand corner
				vScreenUpperLeftCorner = ConvertWorldPtToScreenPt( 
										oRenderSettings,
										new Vector2( (int)-( this.Width/2.0 ),(int)-( this.Height/2.0 ) ) );
				vScreenLowerRightCorner = ConvertWorldPtToScreenPt( 
										oRenderSettings,
										new Vector2( (int)( this.Width/2.0 ),(int)( this.Height/2.0 ) ) );
				oTargetRect = new System.Drawing.Rectangle( 
									(int)vScreenUpperLeftCorner.X,(int)vScreenUpperLeftCorner.Y,
									(int)( vScreenLowerRightCorner.X - vScreenUpperLeftCorner.X ),
									(int)( vScreenLowerRightCorner.Y - vScreenUpperLeftCorner.Y ) );

				//Render the stars
				m_oStarscape.RenderStarScape( oTargetRect );
				#endregion


				if( m_nCurrentScreen == enumGameScreen.InSpace || m_nCurrentScreen == enumGameScreen.CharSheet )
				{
					oaRenderModes = new enumRenderType[]{ enumRenderType.Underside,
														  enumRenderType.Modules, 
														  enumRenderType.Topside,
														  enumRenderType.AboveShip };
					for( int nRenderIdx=0 ; nRenderIdx<oaRenderModes.Length ; nRenderIdx++ )
					{
                        m_oLastRenderSettingsUsed.RenderType = oRenderSettings.RenderType;
                        oRenderSettings = new RenderSettings(m_oLastRenderSettingsUsed);

						foreach( Entity oLoopEntity in oMyZone.Entitys.Values )
                        {
							if( oLoopEntity.IsInPlay == true )
							{
								oRenderSettings = new RenderSettings( m_oAreaToDrawAt,Globals.Inst().OurShip,
									new Vector2(0,0),m_nCurrentZoom,oaRenderModes[ nRenderIdx ],
									m_nCurrentInEditorDisplay,m_nCurrentScreen,
									0,System.Drawing.Color.White );
								oLoopEntity.PreRenderRenderSettingsChange( oRenderSettings );

								oLoopEntity.Render( oRenderSettings );

								#region Debug - Show blue & green overlaps of serverlocation
								if( m_bDebug_Debug == true && oLoopEntity.ServerLocation != null && oLoopEntity.LastServerLocation != null )
								{
									ComplexEntity oAst = new ComplexEntity();
									oAst.Vel = new Vector2( 0,0 );
									oAst.Pos = new Vector2( Globals.Inst().OurShip.Pos.X,Globals.Inst().OurShip.Pos.Y );
									oMyZone.Entitys.Add("TempOnly",oAst );
									ComplexEntity oTempStore = Globals.Inst().OurShip;
									Globals.Inst().OurShip = oAst;
									RenderSettings oTempRenderSettings = new RenderSettings( 
										m_oAreaToDrawAt,Globals.Inst().OurShip,
										new Vector2(0,0),m_nCurrentZoom,oaRenderModes[ nRenderIdx ],
										m_nCurrentInEditorDisplay,m_nCurrentScreen,.5,
										System.Drawing.Color.Blue );
									Location oTempLocation_Real = oLoopEntity.Location;

									oLoopEntity.Location = oLoopEntity.ServerLocation;
									oLoopEntity.Render( oTempRenderSettings );


									oTempRenderSettings.BaseDrawColor = System.Drawing.Color.Green;
									oLoopEntity.Location = oLoopEntity.LastServerLocation;
									oLoopEntity.Render( oTempRenderSettings );

									oLoopEntity.Location = oTempLocation_Real;

									Globals.Inst().OurShip = oTempStore;
                                    oMyZone.Entitys.Remove( "TempOnly");
								}
								#endregion
							}
						}
					}

					//Last but not least render our HUD
                    foreach (Entity oLoopEntity in oMyZone.Entitys.Values)
					{
						oRenderSettings = new RenderSettings( m_oAreaToDrawAt,Globals.Inst().OurShip,
									new Vector2(0,0),m_nCurrentZoom,
									enumRenderType.HUD,m_nCurrentInEditorDisplay,m_nCurrentScreen, 
									0,System.Drawing.Color.White );
						oLoopEntity.Render( oRenderSettings );
					}

					#region Debug - Collision Check ranges
					if( m_bDebug_Collide == true )
					{
						//Check for Collisions
						foreach( Entity oLoopEntity in oMyZone.Entitys.Values )
						{
                            ArrayList oEntity1Regions = oLoopEntity.GetRegions();

							//Now compare the regions for any Collisions
							for( int nReg1Index=0 ; nReg1Index<oEntity1Regions.Count ; nReg1Index++ )
							{
								RegionCircle oLoopReg1 = (RegionCircle)oEntity1Regions[ nReg1Index ];

								Microsoft.DirectX.Vector2 vPos1 = ConvertWorldPtToScreenPt( oRenderSettings,oLoopReg1.Center );

								Vector2 vUpperLeftWrldPt = new Vector2( oLoopReg1.Center.X - oLoopReg1.Radius,oLoopReg1.Center.Y - oLoopReg1.Radius );
								Vector2 vLowerRightWrldPt = new Vector2( oLoopReg1.Center.X + oLoopReg1.Radius,oLoopReg1.Center.Y + oLoopReg1.Radius );
								Vector2 vUpperLeftScrnPt = ConvertWorldPtToScreenPt( oRenderSettings,vUpperLeftWrldPt );
								Vector2 vLowerRightScrnPt = ConvertWorldPtToScreenPt( oRenderSettings,vLowerRightWrldPt );

								System.Drawing.Rectangle oR2 = new System.Drawing.Rectangle( 
									(int)vUpperLeftScrnPt.X,(int)vUpperLeftScrnPt.Y,
									(int)( vLowerRightScrnPt.X - vUpperLeftScrnPt.X ),
									(int)( vLowerRightScrnPt.Y - vUpperLeftScrnPt.Y ) );

								Globals.Inst().GameEngine.RenderTexture2D( 
									"Earth_0",System.Drawing.Rectangle.Empty,oR2,
									Vector2.Empty,//Rotate around
									0,.70,false,System.Drawing.Color.White.ToArgb() );
							} 
						}
					}
					#endregion

					//Render the rolling text
					oRenderSettings = new RenderSettings( m_oAreaToDrawAt,
								Globals.Inst().OurShip,new Vector2(0,0),
								m_nCurrentZoom,enumRenderType.HUD,
								m_nCurrentInEditorDisplay,m_nCurrentScreen,
								0,System.Drawing.Color.White );
					RenderRollingText( oRenderSettings );
				}

                if (Globals.Inst().OurShip != null && Globals.Inst().OurShip.IsDead == false)
                {
                    RenderWoundedParts(Globals.Inst().OurShip);
                }
				
				#region Render the menu buttons
				////////////////////////////////////////////////////////////////////////////////
				//Render the menu button
				////////////////////////////////////////////////////////////////////////////////
				oTargetRect = GetMenuButtonRect();
				Globals.Inst().GameEngine.RenderTexture2D( GraphicConstants.m_cINGAME_MENU,
							System.Drawing.Rectangle.Empty,oTargetRect,System.Drawing.Rectangle.Empty,
							Vector2.Empty,0,0,true,System.Drawing.Color.White.ToArgb() );

				oColor = GraphicConstants.m_cBASICCOLOR;
				if( oTargetRect.Contains( 
							(int)( Globals.Inst().GameEngine.MouseCursor.X ),
							(int)( Globals.Inst().GameEngine.MouseCursor.Y ) )== true )
				{
					oColor = System.Drawing.Color.FromArgb( 192,201,113 );
				}
				Globals.Inst().GameEngine.RenderText( 
						DSResourceManager.GetGlobalInstance().GetFont( GraphicConstants.m_cSLFONT ),
						oTargetRect.X + 27,oTargetRect.Y + 27,oColor,"MENU" );

				//Is the menu open?
				if( m_nMenuTop > 0 )
				{
					oColor = GraphicConstants.m_cBASICCOLOR;
					string[] saText = new string[]{ "MENU", "EDITOR", "CHARACTER" };
					for( int i=0 ; i<3 ; i++ )
					{
						oButtonRect = GetMenuSubButtonRect( i );
						oTextRect = GetMenuSubButtonTextRect( i );
						Globals.Inst().GameEngine.RenderTexture2D( GraphicConstants.m_cINGAME_MENUBULLET,
							System.Drawing.Rectangle.Empty,oButtonRect,System.Drawing.Rectangle.Empty,
							Vector2.Empty,0,0,true,System.Drawing.Color.White.ToArgb() );

						oColor = GraphicConstants.m_cBASICCOLOR;
						if( oButtonRect.Contains(	(int)( Globals.Inst().GameEngine.MouseCursor.X ),
													(int)( Globals.Inst().GameEngine.MouseCursor.Y ) )== true ||
							oTextRect.Contains(	(int)( Globals.Inst().GameEngine.MouseCursor.X ),
												(int)( Globals.Inst().GameEngine.MouseCursor.Y ) )== true )
						{
							oColor = System.Drawing.Color.FromArgb( 192,201,113 );
						}

						Globals.Inst().GameEngine.RenderText( 
							DSResourceManager.GetGlobalInstance().GetFont( GraphicConstants.m_cSLFONT ),
							oTextRect.X,oTextRect.Y,oColor,saText[ i ] );
					}
				}


				////////////////////////////////////////////////////////////////////////////////
				//Render the energy bars
				////////////////////////////////////////////////////////////////////////////////
				if( Globals.Inst().OurShip != null && Globals.Inst().OurShip.IsDead == false )
				{
					oTex = DSResourceManager.GetGlobalInstance().GetLoadedTexture( GraphicConstants.m_cINGAME_ENERGYBAR );
					oTargetRect = new System.Drawing.Rectangle( 0,
							(int)( Globals.Inst().GameEngine.ScreenHeight - oTex.Size.Y ),
							(int)oTex.Size.X,(int)oTex.Size.Y );
					Globals.Inst().GameEngine.RenderTexture2D( GraphicConstants.m_cINGAME_ENERGYBAR,
							System.Drawing.Rectangle.Empty,oTargetRect,System.Drawing.Rectangle.Empty,
							Vector2.Empty,0,0,true,System.Drawing.Color.White.ToArgb() );

					//And energy level...
					oTex = DSResourceManager.GetGlobalInstance().GetLoadedTexture( GraphicConstants.m_cINGAME_ENERGYBAR_ENERGY );
					oTargetRect.Width = (int)oTex.Size.X;
					oTargetRect.Height = (int)oTex.Size.Y;
					oTargetRect.X += 51;
					oTargetRect.Y += 27;
					oClipping = new System.Drawing.Rectangle( oTargetRect.X,oTargetRect.Y,oTargetRect.Width,oTargetRect.Height );
					nPerc = Globals.Inst().OurShip.GetPropertyTotal( enumEntProperties.Energy_CurrentStorage ) / 
							Globals.Inst().OurShip.GetPropertyTotal( enumEntProperties.Energy_MaxStorage );
					oClipping.Width = (int)( (double)oClipping.Width * nPerc );

					Globals.Inst().GameEngine.RenderTexture2D( GraphicConstants.m_cINGAME_ENERGYBAR_ENERGY,
							System.Drawing.Rectangle.Empty,oTargetRect,oClipping,
							Vector2.Empty,0,0,true,System.Drawing.Color.White.ToArgb() );
					//Render the energy text
					Globals.Inst().GameEngine.RenderText( 
						oTargetRect.X+20,oTargetRect.Y,System.Drawing.Color.Black,
						Globals.Inst().OurShip.GetPropertyTotal( enumEntProperties.Energy_CurrentStorage ).ToString( "0" ) + " / " + 
						Globals.Inst().OurShip.GetPropertyTotal( enumEntProperties.Energy_MaxStorage ).ToString( "0" ) );

					//And structure level...
					oTex = DSResourceManager.GetGlobalInstance().GetLoadedTexture( GraphicConstants.m_cINGAME_ENERGYBAR_STRUCT );
					oTargetRect.Width = (int)oTex.Size.X;
					oTargetRect.Height = (int)oTex.Size.Y;
					oTargetRect.X += 16;
					oTargetRect.Y += 33;
					oClipping = new System.Drawing.Rectangle( oTargetRect.X,oTargetRect.Y,oTargetRect.Width,oTargetRect.Height );
					nPerc = Globals.Inst().OurShip.GetPropertyTotal( enumEntProperties.Structure_Current ) / 
							Globals.Inst().OurShip.GetPropertyTotal( enumEntProperties.Structure_Max );
					oClipping.Width = (int)( (double)oClipping.Width * nPerc );

					Globals.Inst().GameEngine.RenderTexture2D( GraphicConstants.m_cINGAME_ENERGYBAR_STRUCT,
							System.Drawing.Rectangle.Empty,oTargetRect,oClipping,
							Vector2.Empty,0,0,true,System.Drawing.Color.White.ToArgb() );
					Globals.Inst().GameEngine.RenderText( 
						oTargetRect.X+20,oTargetRect.Y,System.Drawing.Color.Black,
						Globals.Inst().OurShip.GetPropertyTotal( enumEntProperties.Structure_Current ).ToString( "0" ) + " / " + 
						Globals.Inst().OurShip.GetPropertyTotal( enumEntProperties.Structure_Max ).ToString( "0" ) );



					////////////////////////////////////////////////////////////////////////////////
					//Render the radar
					////////////////////////////////////////////////////////////////////////////////
					nMaxShield = Globals.Inst().OurShip.GetPropertyTotal( enumEntProperties.Shield_Max );
					if( nMaxShield > 0 )
					{
						sTexture = "InGameShieldMeter";
						oTex = DSResourceManager.GetGlobalInstance().GetLoadedTexture( sTexture );
						oTargetRect = new System.Drawing.Rectangle( 
							(int)( Globals.Inst().GameEngine.ScreenWidth - oTex.Size.X ),
							(int)( Globals.Inst().GameEngine.ScreenHeight - oTex.Size.Y ),0,0 );

						//Render the meter
						Globals.Inst().GameEngine.RenderTexture2D(
							sTexture,System.Drawing.Rectangle.Empty,
							oTargetRect,System.Drawing.Rectangle.Empty,oTex.Size,
							0,0,false,System.Drawing.Color.White.ToArgb() );

						//Render the amount
						nPerc = Globals.Inst().OurShip.GetPropertyTotal( enumEntProperties.Shield_Current ) / nMaxShield;
						//0-10
						nShieldLevel = (int)( nPerc / .1 );
						if( nShieldLevel == 0 && nPerc > 0 )
						{
							nShieldLevel = 1;
						}
						sTexture = "ShieldMeter_Amount_" + nShieldLevel.ToString();
						oTargetRect = new System.Drawing.Rectangle( 
							(int)( Globals.Inst().GameEngine.ScreenWidth - oTex.Size.X + 19 ),
							(int)( Globals.Inst().GameEngine.ScreenHeight - oTex.Size.Y + 31 ),0,0 );
						Globals.Inst().GameEngine.RenderTexture2D(
							sTexture,System.Drawing.Rectangle.Empty,
							oTargetRect,System.Drawing.Rectangle.Empty,
							Vector2.Empty,0,0,false,System.Drawing.Color.White.ToArgb() );

						Globals.Inst().GameEngine.RenderText( 
							oTargetRect.X+20,oTargetRect.Y+22,System.Drawing.Color.Black,
							(nPerc * 100).ToString( "000" ) + "%" );
					}
				}
				#endregion



				if( m_nCurrentScreen == enumGameScreen.CharSheet )
				{
					RenderCharSheet();
				}
				else if( m_nCurrentScreen == enumGameScreen.Editor )
				{
					RenderEditor();
				}


				//Write out what we are typing
				if( m_bTyping == true )
				{
					Globals.Inst().GameEngine.RenderText( 20,Globals.Inst().GameEngine.ScreenHeight - 30,
						System.Drawing.Color.White,	"[ Typing: " + m_sTypingText + " ]" );
				}


				if( m_oAlertManager != null )
				{
					m_oAlertManager.RenderAfterForms();
				}

				//m_oWaveManager.Render2DAfterForms();

                #region Render the zone we are on
                oColor = GraphicConstants.m_cBASICCOLOR;
                sMsg = Globals.Inst().MyZone.Name;

                oFont = DSResourceManager.GetGlobalInstance().GetFont(GraphicConstants.m_cSLFONT); 
                Globals.Inst().GameEngine.RenderText(oFont,
                    Globals.Inst().GameEngine.ScreenWidth - sMsg.Length * 11, 15,
                    GraphicConstants.m_cBASICCOLOR, sMsg);
                #endregion

                #region Debug - Write out some useful info
                if ( m_bDebug_Locs == true )
				{
					int nPos = 0;
					string sTemp = "";
					sMsg = "Entity Count: " + oMyZone.Entitys.Count.ToString() + "\nLoc:\n";
                    foreach (Entity oLoopEntity in oMyZone.Entitys.Values)
					{
						sTemp = "";
						if( oLoopEntity == Globals.Inst().OurShip )
						{
							sTemp = "=>";
						}
						sTemp += oLoopEntity.PKey.Substring( 0,5 ) + 
								" (" + oLoopEntity.Pos.X.ToString( "00.0" ) + "," + 
                                       oLoopEntity.Pos.Y.ToString( "00.0" ) + ") " +
								"A:" + oLoopEntity.Angle.ToString( "0.00" ) + " " + 
                                "Zone:" + oLoopEntity.Location.ZoneID.ToString();
						sMsg += sTemp;
						
						//Write out its name
						sTemp = oLoopEntity.GetType().ToString();
						nPos = sTemp.LastIndexOf( "." );
						sTemp = sTemp.Substring( nPos+1 );
						sMsg += sTemp + "\n";
					}
					Globals.Inst().GameEngine.RenderText( 10,100,System.Drawing.Color.White,sMsg );
					//Globals.Inst().GameEngine.RenderText( 10,100,System.Drawing.Color.White,"Loc: (" + Globals.Inst().OurShip.Pos.X.ToString() + "," + Globals.Inst().OurShip.Pos.Y.ToString() + ")" );
				}
				#endregion

				#region Debug - Frame stats
				if( m_bDebug_FPS == true )
				{
					Globals.Inst().GameEngine.RenderText( 0,0,System.Drawing.Color.White,
									Globals.Inst().GameEngine.FrameStats );
				}
				#endregion
			} 
			catch( System.Exception oEx )
			{
				DSMisc.ShowErrors( oEx );
			}
		}
		private void RenderWoundedParts( ComplexEntity oShip )
		{
			RenderSettings oRenderSettings = null;
			Chassis oLoopChassis = null;
			Module oLoopModule = null;
			System.Drawing.Rectangle oParticleRect = Rectangle.Empty;
			System.Drawing.Rectangle oImageRect = Rectangle.Empty;
			System.Drawing.Color oColor = System.Drawing.Color.White;
			double nHPPerc = 0;			
			int nYPos = (int)( Globals.Inst().GameEngine.ScreenHeight * .25 );
			int nXPos = 0;
			int nImageSize = 0;
			int nSpaceSize = 0;
			bool bGoToNextY = false;


			for( int nChassisIndex=0 ; nChassisIndex<Globals.Inst().OurShip.Chasses.Count ; nChassisIndex++ )
			{
				oLoopChassis = (Chassis)Globals.Inst().OurShip.Chasses.GetByIndex( nChassisIndex );
				bGoToNextY = false;
				nImageSize = 30;
				nSpaceSize = 50;
				nXPos = 10;

				//Is this chassis low on HP?
				nHPPerc = oLoopChassis.GetPropertyTotal( enumEntProperties.Structure_Current,false ) /
					oLoopChassis.GetPropertyTotal( enumEntProperties.Structure_Max,false );
				if( nHPPerc < .5 )
				{
					oParticleRect = GetProportionalImageRect( oLoopChassis.CGridWidth,oLoopChassis.CGridHeight,nSpaceSize );
					oParticleRect.X += (int)( nXPos + nSpaceSize / 2.0 - oParticleRect.Width / 2.0 );
					oParticleRect.Y = (int)( nYPos + nSpaceSize / 2.0 - oParticleRect.Height / 2.0 );

					oImageRect = GetProportionalImageRect( oLoopChassis.CGridWidth,oLoopChassis.CGridHeight,nImageSize );
					oImageRect.X += (int)( nXPos + nSpaceSize / 2.0 - oImageRect.Width / 2.0 );
					oImageRect.Y = (int)( nYPos + nSpaceSize / 2.0 - oImageRect.Height / 2.0 );

					//Render the color sphere
					if( nHPPerc < .25 )	{ oColor = System.Drawing.Color.Red; }
					else				{ oColor = System.Drawing.Color.Yellow; }
					Globals.Inst().GameEngine.RenderTexture2D( GraphicConstants.m_cGOB_TRANSPARENTFADEIN,
						System.Drawing.Rectangle.Empty,oParticleRect,Vector2.Empty,0,.5,false,oColor.ToArgb() );

					//Now render it
					oRenderSettings = this.GetBasicEditorRenderSettings( enumRenderType.Topside );
					oRenderSettings.InGameScreen = enumGameScreen.InSpace;
					oRenderSettings.PercentTransparent = .3;
					oLoopChassis.RenderForEditor3D( oImageRect,oRenderSettings );

					//And write the %
					nHPPerc *= 100;
					Globals.Inst().GameEngine.RenderText( nXPos + nSpaceSize / 2.0 - 7,nYPos + nSpaceSize - 8,
												oColor,nHPPerc.ToString( "0" ) + "%" );

					nYPos += 5;
					nXPos += nSpaceSize;
					bGoToNextY = true;
				}
				
				#region Draw the wounded modules
				//Now check the modules for this chassis
				for( int nModuleIdx=0 ; nModuleIdx<oLoopChassis.Modules.Count ; nModuleIdx++ )
				{
					oLoopModule = (Module)oLoopChassis.Modules.GetByIndex( nModuleIdx );
					nImageSize = 20;
					nSpaceSize = 40;

					//Is this chassis low on HP?
					nHPPerc = oLoopModule.GetPropertyTotal( enumEntProperties.Structure_Current,false ) /
							  oLoopModule.GetPropertyTotal( enumEntProperties.Structure_Max,false );
					if( nHPPerc < .5 )
					{
						oParticleRect = GetProportionalImageRect( oLoopModule.MGridWidth,oLoopModule.MGridHeight,nSpaceSize );
						oParticleRect.X += (int)( nXPos + nSpaceSize / 2.0 - oParticleRect.Width / 2.0 );
						oParticleRect.Y = (int)( nYPos + nSpaceSize / 2.0 - oParticleRect.Height / 2.0 );

						oImageRect = GetProportionalImageRect( oLoopModule.MGridWidth,oLoopModule.MGridHeight,nImageSize );
						oImageRect.X += (int)( nXPos + nSpaceSize / 2.0 - oImageRect.Width / 2.0 );
						oImageRect.Y = (int)( nYPos + nSpaceSize / 2.0 - oImageRect.Height / 2.0 );

						//Render the color sphere
						if( nHPPerc < .25 )	{ oColor = System.Drawing.Color.Red; }
						else				{ oColor = System.Drawing.Color.Yellow; }
						Globals.Inst().GameEngine.RenderTexture2D( GraphicConstants.m_cGOB_TRANSPARENTFADEIN,
							System.Drawing.Rectangle.Empty,oParticleRect,Vector2.Empty,0,.5,false,oColor.ToArgb() );

						//Now render it
						oRenderSettings = this.GetBasicEditorRenderSettings( enumRenderType.Modules );
						oRenderSettings.InGameScreen = enumGameScreen.Editor;
						oRenderSettings.EditorDisplay = enumEditorObject.Modules;
						oRenderSettings.PercentTransparent = .3;
						oLoopModule.RenderForEditor3D( oImageRect,oRenderSettings );

						//And write the %
						nHPPerc *= 100; 
						Globals.Inst().GameEngine.RenderText( nXPos + nSpaceSize / 2.0 - 5,nYPos + nSpaceSize - 6,
								oColor,nHPPerc.ToString( "0" ) + "%" );

						nXPos += nImageSize + 4;
						bGoToNextY = true;
					}
				}
				#endregion

				if( bGoToNextY == true )
				{
					nYPos += (int)( nSpaceSize * 1.0 + 10 );
				}
			}
		}
		private System.Drawing.Rectangle GetProportionalImageRect( int nNormalWidth,int nNormalHeight,int nSize )
		{
			double nPerc = 0;
			System.Drawing.Rectangle oImageRect = Rectangle.Empty;


			//Figure out the size of the picture to draw
			if( nNormalWidth > nNormalHeight )
			{
				nPerc = (double)nNormalHeight / (double)nNormalWidth;
				oImageRect = new Rectangle( 0,0,(int)nSize,(int)( nSize * nPerc ) );
			}
			else
			{
				nPerc = (double)nNormalWidth / (double)nNormalHeight;
				oImageRect = new Rectangle( 0,0,(int)( nSize * nPerc ),(int)nSize );
			}

			//oImageRect.X = (int)( nSize / 2.0 - oImageRect.Width / 2.0 );
			//oImageRect.Y = (int)( nSize / 2.0 - oImageRect.Height / 2.0 );

			
			return( oImageRect );
		}
		private void RenderRollingText( RenderSettings oRenderSettings )
		{
			Vector2 vScreenPos = Vector2.Empty;
			RollingText oLoopText = null;


			for( int i=0 ; i<m_oRollingTexts.Count ; i++ )
			{
				if( i >= m_oRollingTexts.Count ){ break; }
				oLoopText = (RollingText)m_oRollingTexts[ i ];

				//Render it!
				vScreenPos = ConvertWorldPtToScreenPt( oRenderSettings,oLoopText.Pos );
				Globals.Inst().GameEngine.RenderText( vScreenPos.X,vScreenPos.Y,
															   oLoopText.Color,oLoopText.Text );
			}
		}
		private void RenderCharSheet()
		{
			ItemSpecialTrait oLoopTrait = null;
			Entity oOurShip = Globals.Inst().OurShip;
			System.Drawing.Rectangle oAreaToDrawAt = Rectangle.Empty;


			//Draw a fancy border
			oAreaToDrawAt = new System.Drawing.Rectangle( 30,30,250,250 );
			Globals.Inst().GameEngine.RenderBorder( oAreaToDrawAt,GobConstants.m_cBORDER_GRAY );

			//Write our our info
			Globals.Inst().GameEngine.RenderText( oAreaToDrawAt.X + 30,oAreaToDrawAt.Y + 30,
				System.Drawing.Color.White,
				"Name: " + Globals.Inst().Profile.Name );
			Globals.Inst().GameEngine.RenderText( oAreaToDrawAt.X + 30,oAreaToDrawAt.Y + 50,
				System.Drawing.Color.White,
				"Level: " + oOurShip.LevelID.ToString() + " (" + oOurShip.EXP.ToString() + " EXP)" );

			if( oOurShip.NextLevelEXP == -1 )
			{
				Globals.Inst().GameEngine.RenderText( oAreaToDrawAt.X + 30,oAreaToDrawAt.Y + 70,
					System.Drawing.Color.White,
					"    (Highest Level Reached)" );
			}
			else
			{
				Globals.Inst().GameEngine.RenderText( oAreaToDrawAt.X + 30,oAreaToDrawAt.Y + 70,
					System.Drawing.Color.White,
					"    (Next Level: " + oOurShip.NextLevelEXP.ToString() + ")" );
			}

			//Render our level specials
			for( int i=0 ; i<oOurShip.LevelSpecialTraits.Count ; i++ )
			{
				oLoopTrait = (ItemSpecialTrait)oOurShip.LevelSpecialTraits[ i ];

				Globals.Inst().GameEngine.RenderText( oAreaToDrawAt.X + 50,oAreaToDrawAt.Y + 90 + 10*i,
					System.Drawing.Color.LightBlue,
					oLoopTrait.GetTraitDescription() + " " + oLoopTrait.Value.ToString() );
			}
		}
		#endregion
		#region Editor Rendering
		private void RenderEditor()
		{
			RenderSettings oRenderSettings = null;
			System.Drawing.Rectangle oInventoryRect = System.Drawing.Rectangle.Empty;
			System.Drawing.Rectangle oTempRect = System.Drawing.Rectangle.Empty;
			System.Drawing.Rectangle oGridArea = System.Drawing.Rectangle.Empty;
			System.Drawing.Point oConnector = System.Drawing.Point.Empty;
			System.Drawing.Point oConflict = System.Drawing.Point.Empty;
			System.Drawing.Point oPlacableLoc = System.Drawing.Point.Empty;
			System.Drawing.Rectangle oR = System.Drawing.Rectangle.Empty;
			System.Drawing.Rectangle oAreaToDrawAt = System.Drawing.Rectangle.Empty;
			Vector2 vPosToDrawAt = Vector2.Empty;
			RedChassis oRedChassis = null;
			int nNumTilesWide = 0, nNumTilesHigh = 0;
			int nShpGridTileSizeX = 0, nShpGridTileSizeY = 0;
			int nGridTileSizeX = 0, nGridTileSizeY = 0;
			int nCX = 0, nCY = 0;
			int nMX = 0, nMY = 0;
			int nSkinRenderIndex = 0;
			double nPerc = 0;
			bool bFound = true;
			bool bRenderOverlaps = false;
			string sTexture = "";
			ArrayList oaConflicts = null;
			//ArrayList oaPlacableLocs = null;
			enumRenderType[] oaRenderModes = null;
			Skin oLoopSkin = null;
			Module oLoopModule = null;
			Chassis oLoopChassis = null;
			DSGobTable oTable = null;


			try
			{
				RenderBasicEditorScreen();

				#region Render Ship
				oRenderSettings = GetBasicEditorRenderSettings( enumRenderType.Modules ); 
				oRenderSettings.EditorDisplay = m_nCurrentInEditorDisplay;
				if( m_nCurrentInEditorDisplay == enumEditorObject.Skins )
				{
					oaRenderModes = new enumRenderType[]{ enumRenderType.Underside,
														  enumRenderType.Modules,
														  enumRenderType.Topside,
														  enumRenderType.AboveShip };
					oRenderSettings.BaseDrawColor = System.Drawing.Color.White;
				}
				else if( m_nCurrentInEditorDisplay == enumEditorObject.Chassis )
				{
					oaRenderModes = new enumRenderType[]{ enumRenderType.Underside,
														  enumRenderType.Modules,
														  enumRenderType.Topside,
														  enumRenderType.AboveShip };
					oRenderSettings.BaseDrawColor = System.Drawing.Color.White;
				}
				else
				{
					oaRenderModes = new enumRenderType[]{ enumRenderType.Underside,
														  enumRenderType.Modules };
					oRenderSettings.BaseDrawColor = System.Drawing.Color.FromArgb( 100,100,100 );
				}

				//Go through all our entitys, we know they won't be changing
				for( int nRenderIdx=0 ; nRenderIdx<oaRenderModes.Length ; nRenderIdx++ )
				{
					oRenderSettings.RenderType = oaRenderModes[ nRenderIdx ];

					for( int nChassisIndex=0 ; nChassisIndex<Globals.Inst().OurShip.Chasses.Count ; nChassisIndex++ )
					{
						oLoopChassis = (Chassis)Globals.Inst().OurShip.Chasses.GetByIndex( nChassisIndex );

						oR = GetGridRectForChassis( oLoopChassis.XOffset,oLoopChassis.YOffset );
						oTempRect = GetGridRectForChassis( oLoopChassis.XOffset+oLoopChassis.CGridWidth,oLoopChassis.YOffset+oLoopChassis.CGridHeight );
						oR.Width = oTempRect.Left - oR.Left;
						oR.Height = oR.Top - oTempRect.Top;

						#region Render the chassis red for failed removal attempts
						//If we are rendering chassis, make sure to flare them red
						oRenderSettings.BaseDrawColor = System.Drawing.Color.White;
						if( oRenderSettings.RenderType == enumRenderType.Topside )
						{
							//Do we have a chassis flaring?
							if( m_oRedChasses.ContainsKey( oLoopChassis.PKey ) == true )
							{
								oRedChassis = (RedChassis)m_oRedChasses.GetByKey( oLoopChassis.PKey );
								nPerc = ( Globals.Inst().GameEngine.AppTime - oRedChassis.m_nTimeRedStarted ) / oRedChassis.m_nTimeRed;
								if( nPerc >= 1 )
								{
									m_oRedChasses.Remove( oLoopChassis.PKey );
								}
								else
								{
									//Otherwise, make our chassis draw red
									oRenderSettings.BaseDrawColor = System.Drawing.Color.FromArgb( 
														255,(int)( nPerc * 255.0 ),(int)( nPerc * 255.0 ) );
								}
							}							
						}
						#endregion


						oLoopChassis.RenderForEditor3D( oR,oRenderSettings );
					}
				}
				#endregion
				
				#region Render unasigned parts
				DSSortedList oItemList = new DSSortedList();
				InventoryItems oInvItem = null;
				//Now render
				if( m_nCurrentInEditorDisplay == enumEditorObject.Chassis )
				{
					for( int i=Globals.Inst().Profile.UnassignedChassis.Count-1 ; i>=0 ; i-- )
					{
						oLoopChassis = (Chassis)Globals.Inst().Profile.UnassignedChassis.GetByIndex( i );

						//Is this chassis on this page?
						if( oLoopChassis.XOffset >= m_nChassisPage * m_cEDITOR_GRID_WIDTH_CHASSIS &&
							oLoopChassis.XOffset < ( m_nChassisPage + 1 ) * m_cEDITOR_GRID_WIDTH_CHASSIS &&
							oLoopChassis.Active == true )
						{
                            //03/10/2008 Chris Hill  Can't use stacks for now, our items are all unique.
							/*if( oLoopChassis.SpecialTraits.Count == 0 )
							{
								//Record it for stacking
								oInvItem = (InventoryItems)oItemList.GetByKey( oLoopChassis.Name.ToString() );
								if( oInvItem == null )
								{
									oInvItem = new InventoryItems();
									oInvItem.m_nXOffset = oLoopChassis.XOffset;
									oInvItem.m_nYOffset = oLoopChassis.YOffset;
									oInvItem.m_nWidth = oLoopChassis.CGridWidth;
									oInvItem.m_nHeight = oLoopChassis.CGridHeight;
									oItemList.Add( oLoopChassis.Name.ToString(),oInvItem );
								}
								oInvItem.m_nNumItems++;
								oLoopChassis.XOffset = oInvItem.m_nXOffset;
								oLoopChassis.YOffset = oInvItem.m_nYOffset;
							}
							else
							{
								oInvItem = null;
							}*/

							//Render it if its the first one on our list
							if( oInvItem == null || oInvItem.m_nNumItems == 1 )
							{
								//Render the chassis itself
								oR = GetGridRectForUnassignedChassis( oLoopChassis.XOffset,oLoopChassis.YOffset );
								oTempRect = GetGridRectForUnassignedChassis( 
									oLoopChassis.XOffset + oLoopChassis.CGridWidth,
									oLoopChassis.YOffset + oLoopChassis.CGridHeight );
								oR.Width = oTempRect.Left - oR.Left;
								oR.Height = oR.Top - oTempRect.Top;

								//Render the chassis white
								oRenderSettings = GetBasicEditorRenderSettings( enumRenderType.Underside );
								oRenderSettings.EditorDisplay = enumEditorObject.Unassigned;
								oLoopChassis.RenderForEditor3D( oR,oRenderSettings ); 

								if( oLoopChassis.MinLevel > Globals.Inst().OurShip.LevelID )
								{
									oRenderSettings.BaseDrawColor = System.Drawing.Color.Red;
								}
								oRenderSettings.RenderType = enumRenderType.Topside;
								oLoopChassis.RenderForEditor3D( oR,oRenderSettings ); 
							}
						}
					}

					//Now display the count
					/*for( int i=0 ; i<oItemList.Count ; i++ )
					{
						//Record it for stacking
						oInvItem = (InventoryItems)oItemList.GetByIndex( i );

						//Draw the count
						if( oInvItem != null )
						{
							oTempRect = GetGridRectForUnassignedChassis( 
								oInvItem.m_nXOffset + oInvItem.m_nWidth,
								oInvItem.m_nYOffset - oInvItem.m_nHeight );
							Globals.Inst().GameEngine.RenderText( 
								oTempRect.Left,oTempRect.Top - 12,
								System.Drawing.Color.White,"x" + oInvItem.m_nNumItems );
						}
					}*/
				}
				else if( m_nCurrentInEditorDisplay == enumEditorObject.Modules )
				{
					oInventoryRect = GetInvGridDetails( enumEditorObject.Modules,ref nNumTilesWide,ref nNumTilesHigh,ref nGridTileSizeX,ref nGridTileSizeY );

					for( int i=Globals.Inst().Profile.UnassignedModules.Count-1 ; i>=0 ; i-- )
					{
						oLoopModule = (Module)Globals.Inst().Profile.UnassignedModules.GetByIndex( i );

						//Is this module on this page?
						if( oLoopModule.XOffset >= m_nModulePage * m_cEDITOR_GRID_WIDTH_MODULE &&
							oLoopModule.XOffset < ( m_nModulePage + 1 ) * m_cEDITOR_GRID_WIDTH_MODULE && 
							oLoopModule.Active == true )
						{
                            //03/10/2008 Chris Hill  Can't use stacks for now, our items are all unique.
							/*if( oLoopModule.SpecialTraits.Count == 0 )
							{
								//Record it for stacking
								oInvItem = (InventoryItems)oItemList.GetByKey( oLoopModule.Name.ToString() );
								if( oInvItem == null )
								{
									oInvItem = new InventoryItems();
									oInvItem.m_nXOffset = oLoopModule.XOffset;
									oInvItem.m_nYOffset = oLoopModule.YOffset;
									oInvItem.m_nWidth = oLoopModule.MGridWidth;
									oInvItem.m_nHeight = oLoopModule.MGridHeight;
									oItemList.Add( oLoopModule.Name.ToString(),oInvItem );
								}
								oInvItem.m_nNumItems++;
								oLoopModule.XOffset = oInvItem.m_nXOffset;
								oLoopModule.YOffset = oInvItem.m_nYOffset;
							}
							else
							{
								oInvItem = null;
							}*/

							//Render it if its the first one on our list
							if( oInvItem == null || oInvItem.m_nNumItems == 1 )
							{
								//Render the module itself
								oR = GetGridRectForUnassignedModule( oLoopModule.XOffset,oLoopModule.YOffset );
								oTempRect = GetGridRectForUnassignedModule( 
									oLoopModule.XOffset + oLoopModule.MGridWidth,
									oLoopModule.YOffset + oLoopModule.MGridHeight );
								oR.Width = oTempRect.Left - oR.Left;
								oR.Height = oR.Top - oTempRect.Top;

								oRenderSettings = GetBasicEditorRenderSettings( enumRenderType.Modules );
								if( oLoopModule.MinLevel > Globals.Inst().OurShip.LevelID )
								{
									oRenderSettings.BaseDrawColor = System.Drawing.Color.Red;
								}
								oRenderSettings.EditorDisplay = enumEditorObject.Unassigned;
								oLoopModule.RenderForEditor3D( oR,oRenderSettings ); 
							}
						}
					}

					//Now display the count
					/*for( int i=0 ; i<oItemList.Count ; i++ )
					{
						//Record it for stacking
						oInvItem = (InventoryItems)oItemList.GetByIndex( i );
					
						if( oInvItem != null )
						{
							//Draw the count
							oTempRect = GetGridRectForUnassignedModule( 
								oInvItem.m_nXOffset + oInvItem.m_nWidth,
								oInvItem.m_nYOffset - oInvItem.m_nHeight );
							Globals.Inst().GameEngine.RenderText( 
								oTempRect.Left,oTempRect.Top-12,System.Drawing.Color.White,"x" + oInvItem.m_nNumItems );
						}
					}*/
				}
				else if( m_nCurrentInEditorDisplay == enumEditorObject.Skins )
				{
					oInventoryRect = GetInvGridDetails( enumEditorObject.Skins,ref nNumTilesWide,ref nNumTilesHigh,ref nGridTileSizeX,ref nGridTileSizeY );

					nSkinRenderIndex = 0;
					for( int i=0 ; i<Globals.Inst().Profile.UnassignedSkins.Count ; i++ )
					{
						oLoopSkin = (Skin)Globals.Inst().Profile.UnassignedSkins.GetByIndex( i );

						//Record it for stacking, if its on this page
						if( oLoopSkin.DBSkinID > 0 &&
							nSkinRenderIndex >= m_nSkinPage * nNumTilesHigh &&
							nSkinRenderIndex < ( m_nSkinPage + 1 ) * nNumTilesHigh )
						{
							oInvItem = (InventoryItems)oItemList.GetByKey( oLoopSkin.DBSkinID.ToString() );
							if( oInvItem == null )
							{
								oInvItem = new InventoryItems();
								oInvItem.m_nYOffset = nSkinRenderIndex;
								oItemList.Add( oLoopSkin.DBSkinID.ToString(),oInvItem );
							}
							oInvItem.m_nNumItems++;

							//Render it if its the first one on our list
							if( oInvItem.m_nNumItems == 1 )
							{
								oTable = DSResourceManager.GetGlobalInstance().GetGobTable( GobConstants.m_cTABLE_SKINS );
								sTexture = (string)oTable.FindValue( GobConstants.m_cCLMN_SKINID,oLoopSkin.DBSkinID,GobConstants.m_cCLMN_SKINTEXTURENAME,true );

								oR = GetGridRectForUnassignedSkin( nSkinRenderIndex );
								Globals.Inst().GameEngine.RenderTexture2D( sTexture,Rectangle.Empty,oR,Vector2.Empty,0,0,
									false,System.Drawing.Color.White.ToArgb() );
								nSkinRenderIndex++;
							}
						}
					}

					//Now display the count
					for( int i=0 ; i<oItemList.Count ; i++ )
					{
						//Record it for stacking
						oInvItem = (InventoryItems)oItemList.GetByIndex( i );

						//Draw the count
						if( oInvItem.m_nNumItems > 0 )
						{
							oTempRect = GetGridRectForUnassignedSkin( oInvItem.m_nYOffset );
							Globals.Inst().GameEngine.RenderText( 
								oTempRect.Right+5,oTempRect.Bottom-12,System.Drawing.Color.White,"x" + oInvItem.m_nNumItems );
						}
					}
				}
				#endregion
		          
				#region Render Dragging Module
				//Render dragging Modules
				if( m_oDraggingModule != null )
				{
					bFound = false;

					//Find the chassis this works for
					nMX = MGetEntityGridX( null,Globals.Inst().GameEngine.MouseCursor );
					nMY = MGetEntityGridY( null,Globals.Inst().GameEngine.MouseCursor );

					if( Globals.Inst().OurShip.CanModuleBePlaced( m_oDraggingModule,nMX,nMY,ref oaConflicts,ref oLoopChassis ) == true )
					{
						bFound = true;
						oR = GetGridRectForModule( oLoopChassis.XOffset,oLoopChassis.YOffset,
									nMX - oLoopChassis.XOffset,nMY - oLoopChassis.YOffset );
						oTempRect = GetGridRectForModule( oLoopChassis.XOffset,oLoopChassis.YOffset,
									nMX - oLoopChassis.XOffset + m_oDraggingModule.MGridWidth,
									nMY - oLoopChassis.YOffset + m_oDraggingModule.MGridHeight );
						oR.Width = oTempRect.Left - oR.Left;
						oR.Height = oR.Top - oTempRect.Top;
					}

					if( bFound == false )
					{
						oInventoryRect = GetInvGridDetails( enumEditorObject.Modules,ref nNumTilesWide,ref nNumTilesHigh,ref nGridTileSizeX,ref nGridTileSizeY );

						oR = new System.Drawing.Rectangle( 
							(int)( Globals.Inst().GameEngine.MouseCursor.X ),
							(int)( Globals.Inst().GameEngine.MouseCursor.Y ),0,0 );
						
						if( oInventoryRect.Contains( (int)Globals.Inst().GameEngine.MouseCursor.X,
													 (int)Globals.Inst().GameEngine.MouseCursor.Y ) == false )
						{
							oInventoryRect = GetShipGridDetails( ref nNumTilesWide,ref nNumTilesHigh,ref nGridTileSizeX,ref nGridTileSizeY );
						}
						oR.Width = nGridTileSizeX * m_oDraggingModule.MGridWidth;
						oR.Height = nGridTileSizeY * m_oDraggingModule.MGridHeight;
					}

					//Now draw the dragging module, in red if necessary
					oRenderSettings = GetBasicEditorRenderSettings( enumRenderType.Modules );
					oRenderSettings.EditorDisplay = enumEditorObject.Unassigned;
					if( m_oDraggingModule.MinLevel > Globals.Inst().OurShip.LevelID )
					{
						oRenderSettings.BaseDrawColor = System.Drawing.Color.Red;
					}
					m_oDraggingModule.RenderForEditor3D( oR,oRenderSettings );


					#region Draw the overlaps
					//Now, weather or not its placed, draw the overlaps.  Got to have a chassis though
					if( bFound == true )
					{
						for( int nConflictIndex=0 ; nConflictIndex<oaConflicts.Count ; nConflictIndex++ )
						{
							oConflict = (System.Drawing.Point)oaConflicts[ nConflictIndex ];
							oR = GetGridRectForModule( oLoopChassis.XOffset,oLoopChassis.YOffset,oConflict.X,oConflict.Y );

							Globals.Inst().GameEngine.RenderTexture2D( 
								GraphicConstants.m_cGRID_RED,
								System.Drawing.Rectangle.Empty,oR,
								Vector2.Empty,//Rotate around
								0,0,false,System.Drawing.Color.White.ToArgb() );
						}
					}
					#endregion

					#region Render dragging module potential locations
					//Gather some inventory information
					GetShipGridDetails( ref nNumTilesWide,ref nNumTilesHigh,ref nShpGridTileSizeX,ref nShpGridTileSizeY );

					if( m_oaDraggingModulePlacableLocs != null )
					{
						//We calculate this in a thread now because for large modules its slow
						//oaPlacableLocs = Globals.Inst().OurShip.GetMGridPlacableLocs( m_oDraggingModule );

						for( int nPlacableLocIndex=0 ; nPlacableLocIndex<m_oaDraggingModulePlacableLocs.Count ; nPlacableLocIndex++ )
						{
							oPlacableLoc = (System.Drawing.Point)m_oaDraggingModulePlacableLocs[ nPlacableLocIndex ];

							//Green out the locations we can place at
							for( int nMXRender=0 ; nMXRender<m_oDraggingModule.MGridWidth ; nMXRender++ )
							{
								for( int nMYRender=0 ; nMYRender<m_oDraggingModule.MGridHeight ; nMYRender++ )
								{
									oR = GetGridRectForModule( 0,0,oPlacableLoc.X,oPlacableLoc.Y );
									oR.Width = nShpGridTileSizeX * m_oDraggingModule.MGridWidth;
									oR.Height = nShpGridTileSizeY * m_oDraggingModule.MGridHeight;
									Globals.Inst().GameEngine.RenderTexture2D( GraphicConstants.m_cGRID_POTENTIAL,
										System.Drawing.Rectangle.Empty,oR,Vector2.Empty,
										0,0,false,System.Drawing.Color.Green.ToArgb() );
								}
							}
						}
					}
					#endregion
				}
				#endregion

				#region Render Dragging Chassis
				//Render dragging Chassis
				if( m_oDraggingChassis != null )
				{
					oInventoryRect = GetInvGridDetails( enumEditorObject.Chassis,ref nNumTilesWide,ref nNumTilesHigh,ref nGridTileSizeX,ref nGridTileSizeY );

					//Unassigned chassis
					if( oInventoryRect.Contains( (int)Globals.Inst().GameEngine.MouseCursor.X,
												 (int)Globals.Inst().GameEngine.MouseCursor.Y ) == true )
					{
						nCX = CGetUnassignedGridX( Globals.Inst().GameEngine.MouseCursor );
						nCY = CGetUnassignedGridY( Globals.Inst().GameEngine.MouseCursor );
						oR = GetGridRectForUnassignedChassis( nCX,nCY );

						oTempRect = GetGridRectForUnassignedChassis( nCX + m_oDraggingChassis.CGridWidth,
										nCY + m_oDraggingChassis.CGridHeight );
						oR.Width = oTempRect.Left - oR.Left;
						oR.Height = oR.Top - oTempRect.Top;
					}
					//Assigned chassis
					else
					{
						bRenderOverlaps = true;

						nCX = CGetEntityGridX( Globals.Inst().GameEngine.MouseCursor );
						nCY = CGetEntityGridY( Globals.Inst().GameEngine.MouseCursor );
						oR = GetGridRectForChassis( nCX,nCY );

						oTempRect = GetGridRectForChassis( nCX + m_oDraggingChassis.CGridWidth,
														   nCY + m_oDraggingChassis.CGridHeight );
						oR.Width = oTempRect.Left - oR.Left;
						oR.Height = oR.Top - oTempRect.Top;
					}

					//Now render the peice, in red if necessary
					oRenderSettings = GetBasicEditorRenderSettings( enumRenderType.Underside );
					if( m_oDraggingChassis.MinLevel > Globals.Inst().OurShip.LevelID )
					{
						oRenderSettings.BaseDrawColor = System.Drawing.Color.Red;
					}
					m_oDraggingChassis.RenderForEditor3D( oR,oRenderSettings );
					oRenderSettings.RenderType = enumRenderType.Topside;
					m_oDraggingChassis.RenderForEditor3D( oR,oRenderSettings );

					#region Render dragging chassis overlaps
					if( bRenderOverlaps == true &&
						Globals.Inst().OurShip.CanChassisBePlaced( m_oDraggingChassis,nCX,nCY,ref oaConflicts ) == false )
					{
						int nX = 0;
						int nY = 0;

						for( int nConflictIndex=0 ; nConflictIndex<oaConflicts.Count ; nConflictIndex++ )
						{
							oConflict = (System.Drawing.Point)oaConflicts[ nConflictIndex ];
							nX = oConflict.X + nCX;
							nY = oConflict.Y + nCY - 1;

							oR = GetGridRectForChassis( nX,nY );							
							oTempRect = GetGridRectForChassis( nX+1,nY+1 );
							oR.Width = oTempRect.Left - oR.Left;
							oR.Height = oTempRect.Top - oR.Top;

							Globals.Inst().GameEngine.RenderTexture2D( 
								GraphicConstants.m_cGRID_RED,
								System.Drawing.Rectangle.Empty,oR,
								Vector2.Empty,//Rotate around
								0,.3,false,System.Drawing.Color.White.ToArgb() );
						}
					}
					#endregion
				}
				#endregion      

				#region Render Dragging Skin
				//Render dragging Modules
				if( m_oDraggingSkin != null )
				{
					bFound = false;

					//Find the chassis this works for
					//To Do...

					if( bFound == false )
					{
						oR = new System.Drawing.Rectangle( 
							(int)( Globals.Inst().GameEngine.MouseCursor.X ),
							(int)( Globals.Inst().GameEngine.MouseCursor.Y ),50,50 );
					}

					//Get our texture key
					oTable = DSResourceManager.GetGlobalInstance().GetGobTable( GobConstants.m_cTABLE_SKINS );
					sTexture = (string)oTable.FindValue( GobConstants.m_cCLMN_SKINID,m_oDraggingSkin.DBSkinID,GobConstants.m_cCLMN_SKINTEXTURENAME );

					Globals.Inst().GameEngine.RenderTexture2D( sTexture,Rectangle.Empty,oR,Vector2.Empty,0,0,false,System.Drawing.Color.White.ToArgb() );
				}
				#endregion

				#region Render Stats in corner
				double nTempX = Globals.Inst().GameEngine.ScreenWidth * .80;
				double nTempY = Globals.Inst().GameEngine.ScreenHeight * .80;
				double nWidth = Globals.Inst().GameEngine.ScreenWidth * .18;
				double nHeight = Globals.Inst().GameEngine.ScreenHeight * .1;
				double nBorderX = Globals.Inst().GameEngine.ScreenWidth * .003;
				double nBorderY = Globals.Inst().GameEngine.ScreenHeight * .003;
				double nMass = 0; 
				double nThrust = 0;

				//Display the render area
				Globals.Inst().GameEngine.RenderRect2D( 
								new Rectangle( (int)( nTempX - nBorderX ),(int)( nTempY - nBorderY ),
											   (int)( nWidth + nBorderX * 2 ),(int)( nHeight + nBorderY * 2 ) ),
								System.Drawing.Color.Black.ToArgb(),.5 );
				Globals.Inst().GameEngine.RenderRect2D( 
								new Rectangle( (int)nTempX,(int)nTempY,(int)nWidth,(int)nHeight ),
								System.Drawing.Color.Gray.ToArgb(),.7 );

				//Render our mass
				nMass = Globals.Inst().OurShip.GetPropertyTotal( enumEntProperties.Structure_Mass );
				Globals.Inst().GameEngine.RenderText( nTempX + nWidth * .05,nTempY + nHeight * .05,
						System.Drawing.Color.White,
						"Mass: " + nMass.ToString( "0" ) + " tons" );

				//Render our Thrust
				nThrust = Globals.Inst().OurShip.GetPropertyTotal( enumEntProperties.Movement_LinearThrust_Max );
				nThrust = nThrust / nMass;
				Globals.Inst().GameEngine.RenderText( nTempX + nWidth * .05,nTempY + nHeight * .05 + 20,
					System.Drawing.Color.White,
					"Thrust: " + nThrust.ToString( "0" ) + " per s" );
				#endregion

				#region Render Mouse Hover Stuff
				//Check the mouse hover stuff
				if( Globals.Inst().IAmTheServer == false &&
					m_bHaveStartedHovering == true && m_oCurrentMouseHoverPart != null )
				{
					vPosToDrawAt = new Vector2( (int)m_vMouseHoverPoint.X,(int)m_vMouseHoverPoint.Y );

					if( Globals.ObjectIsModule( m_oCurrentMouseHoverPart ) == true )
					{
						((Module)m_oCurrentMouseHoverPart).HoverRender3D();
					}
					else if( Globals.ObjectIsChassis( m_oCurrentMouseHoverPart ) == true )
					{
						((Chassis)m_oCurrentMouseHoverPart).HoverRender3D();
					}			
				}
				#endregion


				#region Display the grid X,Y we are hovering over
				//Find out what grid we clicked on
				if( m_bDebug_Debug == true )
				{
					int nX2 = 0, nY2 = 0;
					if( m_nCurrentInEditorDisplay == enumEditorObject.Chassis )
					{
						nX2 = CGetEntityGridX( Globals.Inst().GameEngine.MouseCursor );
						nY2 = CGetEntityGridY( Globals.Inst().GameEngine.MouseCursor );
						if( nX2 < -11 )
						{
							nX2 = CGetUnassignedGridX( Globals.Inst().GameEngine.MouseCursor );
							nY2 = CGetUnassignedGridY( Globals.Inst().GameEngine.MouseCursor );
						}
					}
					else if( m_nCurrentInEditorDisplay == enumEditorObject.Modules )
					{
						nX2 = MGetEntityGridX( null,Globals.Inst().GameEngine.MouseCursor );
						nY2 = MGetEntityGridY( null,Globals.Inst().GameEngine.MouseCursor );
						if( nX2 < -11 )
						{
							nX2 = MGetUnassignedGridX( Globals.Inst().GameEngine.MouseCursor );
							nY2 = MGetUnassignedGridY( Globals.Inst().GameEngine.MouseCursor );
						}
					}
					else if( m_nCurrentInEditorDisplay == enumEditorObject.Skins )
					{
						nX2 = 0;
						nY2 = SGetUnassignedGridY( Globals.Inst().GameEngine.MouseCursor );
					}
					Globals.Inst().GameEngine.RenderText( 0,100,System.Drawing.Color.White,"Grid: (" + nX2.ToString() + "," + nY2.ToString() + ")" );
				}
				#endregion
			}
			catch( System.Exception oEx )
			{
				DSMisc.ShowErrors( oEx );
			}
		}
		private void RenderBasicEditorScreen()
		{
			System.Drawing.Rectangle oInventoryRect = Rectangle.Empty;
			System.Drawing.Rectangle oTargetRect = Rectangle.Empty;
			System.Drawing.Rectangle oAreaToDraw = Rectangle.Empty;
			System.Drawing.Rectangle oShipRect = Rectangle.Empty;
			System.Drawing.Color nArrowColor = System.Drawing.Color.White;
			int nPage = 0;
			int nBorder = 8;
			int nShipLeft = 0;
			int nTabStartLeft = 0;
			int nDifference = 0;
			//int nHeight = 0;
			int nNumTilesWide = 0, nNumTilesHigh = 0;
			int nShpGridTileSizeX = 0, nShpGridTileSizeY = 0;
			int nInvGridTileSizeX = 0, nInvGridTileSizeY = 0;
			string sGraphicKey = "";
			string sText = "";


			//Gather some inventory information
			oInventoryRect = GetInvGridDetails( m_nCurrentInEditorDisplay,ref nNumTilesWide,ref nNumTilesHigh,ref nInvGridTileSizeX,ref nInvGridTileSizeY );
			nShipLeft = oInventoryRect.Right - GobConstants.m_cBORDER_GRAY_RIGHTSIZE;
			nTabStartLeft = nShipLeft + 80;
			oShipRect = GetShipGridDetails( ref nNumTilesWide,ref nNumTilesHigh,ref nShpGridTileSizeX,ref nShpGridTileSizeY );


			////////////////////////////////////////////////////////////////////////////////////
			// Draw the tabs
			////////////////////////////////////////////////////////////////////////////////////
			for( int i=0 ; i<m_cNUMBEROFTABS ; i++ )
			{
				oTargetRect = GetTabRect( i,ref sText );

				Globals.Inst().GameEngine.RenderTexture2D( GobConstants.m_cEDITOR_TAB,
					Rectangle.Empty,oTargetRect,Rectangle.Empty,Vector2.Empty,0,0,false,
					System.Drawing.Color.White.ToArgb() );
				Globals.Inst().GameEngine.RenderText( 
					oTargetRect.X + 32,oTargetRect.Y + 5,
					System.Drawing.Color.Black,sText );
			}


			////////////////////////////////////////////////////////////////////////////////////
			#region Draw the grids
			////////////////////////////////////////////////////////////////////////////////////
			//Draw the ship border
			oAreaToDraw = new Rectangle( 
				oShipRect.X - GobConstants.m_cBORDER_GRAY_LEFTSIZE,
				oShipRect.Y - GobConstants.m_cBORDER_GRAY_TOPSIZE,
				oShipRect.Width + GobConstants.m_cBORDER_GRAY_LEFTSIZE + GobConstants.m_cBORDER_GRAY_RIGHTSIZE,
				oShipRect.Height + GobConstants.m_cBORDER_GRAY_TOPSIZE + GobConstants.m_cBORDER_GRAY_BOTTOMSIZE );
			Globals.Inst().GameEngine.RenderBorder( oAreaToDraw,GobConstants.m_cBORDER_GRAY ); 

			//Draw the ship grid
			RenderGrid( GraphicConstants.m_cGOB_GRAPHICS_GRID,oShipRect.X,oShipRect.Y,oShipRect.Width,oShipRect.Height,nShpGridTileSizeX,nShpGridTileSizeY );

			//Draw the main inventory border
			oAreaToDraw = new Rectangle( 
				oInventoryRect.X - GobConstants.m_cBORDER_GRAY_LEFTSIZE,
				oInventoryRect.Y - GobConstants.m_cBORDER_GRAY_TOPSIZE,
				oInventoryRect.Width + GobConstants.m_cBORDER_GRAY_LEFTSIZE + GobConstants.m_cBORDER_GRAY_RIGHTSIZE,
				oInventoryRect.Height + GobConstants.m_cBORDER_GRAY_TOPSIZE + GobConstants.m_cBORDER_GRAY_BOTTOMSIZE );
			Globals.Inst().GameEngine.RenderBorder( oAreaToDraw,GobConstants.m_cBORDER_GRAY ); 

			//Render
			if( m_nCurrentInEditorDisplay != enumEditorObject.Skins )
			{
				RenderGrid( GraphicConstants.m_cGOB_GRAPHICS_GRID,
					oInventoryRect.X,oInventoryRect.Y,oInventoryRect.Width,oInventoryRect.Height,
					nInvGridTileSizeX,nInvGridTileSizeY );
			}
			#endregion


			////////////////////////////////////////////////////////////////////////////////////
			#region Render the arrows at the bottom
			////////////////////////////////////////////////////////////////////////////////////
			nDifference = (int)( ( oInventoryRect.Width - GobConstants.m_cEDITOR_ARROWWIDTH * 4 ) / 5.0 );
			oTargetRect = new Rectangle(
				nBorder + GobConstants.m_cBORDER_GRAY_LEFTSIZE + nDifference,
				Globals.Inst().GameEngine.ScreenHeight - nBorder - GobConstants.m_cBORDER_GRAY_BOTTOMSIZE - 23 - 5,0,0 );
			//Figure out our page
			//Set the colors logically
				 if( m_nCurrentInEditorDisplay == enumEditorObject.Chassis ){ nPage = m_nChassisPage; }
			else if( m_nCurrentInEditorDisplay == enumEditorObject.Modules ){ nPage = m_nModulePage; }
			else if( m_nCurrentInEditorDisplay == enumEditorObject.Skins )	{ nPage = m_nSkinPage; }
			else
			{
				nPage = 0;
			}
			//Zero our colors to white first
			for( int i=0 ; i<4 ; i++ )
			{
				oTargetRect = GetArrowRect( i,ref sGraphicKey );

				if( oTargetRect.Contains(	(int)Globals.Inst().GameEngine.MouseCursor.X,
					(int)Globals.Inst().GameEngine.MouseCursor.Y ) == true )
				{
					nArrowColor = System.Drawing.Color.LightBlue;
				}
				else
				{
					nArrowColor = System.Drawing.Color.White;
				}
				//Set the colors logically
				if( nPage == 0 && ( i == 0 || i == 1 ) )
				{
					nArrowColor = System.Drawing.Color.Gray;
					nArrowColor = System.Drawing.Color.Gray;
				}

				Globals.Inst().GameEngine.RenderTexture2D( sGraphicKey,
					Rectangle.Empty,oTargetRect,Rectangle.Empty,Vector2.Empty,0,0,false,
					nArrowColor.ToArgb() );
			}

			//Draw our page
			if( nPage > 0 )
			{
				Globals.Inst().GameEngine.RenderText( oInventoryRect.X,oInventoryRect.Y - 21,
					System.Drawing.Color.White,"Page " + nPage.ToString() );
			}
			#endregion
		}


		private System.Drawing.Rectangle GetInvGridDetails( enumEditorObject nGridType,
														 ref int nNumTilesWide,ref int nNumTilesHigh,
														 ref int nGridTileSizeX, ref int nGridTileSizeY )
		{
			int nBorder = 8;
			int nInventoryWidth = (int)( Globals.Inst().GameEngine.ScreenWidth * .25f );
			System.Drawing.Rectangle oInventoryArea = System.Drawing.Rectangle.Empty;


			oInventoryArea = new System.Drawing.Rectangle( 
						nBorder + GobConstants.m_cBORDER_GRAY_LEFTSIZE,
						nBorder + GobConstants.m_cBORDER_GRAY_TOPSIZE,
						nInventoryWidth,
						Globals.Inst().GameEngine.ScreenHeight - nBorder * 2 - GobConstants.m_cBORDER_GRAY_TOPSIZE - GobConstants.m_cBORDER_GRAY_BOTTOMSIZE);

			//Render
			if( m_nCurrentInEditorDisplay == enumEditorObject.Chassis )
			{
				nGridTileSizeX = 15;
				nGridTileSizeY = 15;
			}
			else if( m_nCurrentInEditorDisplay == enumEditorObject.Modules )
			{
				nGridTileSizeX = 30;
				nGridTileSizeY = 30;
			}
			else if( m_nCurrentInEditorDisplay == enumEditorObject.Skins )
			{
				nGridTileSizeX = 150;
				nGridTileSizeY = 25;
			}

			//Now shrink the inventory area to make it a tight fit
			if( m_nCurrentInEditorDisplay != enumEditorObject.Skins )
			{
				nNumTilesWide = (int)( (double)oInventoryArea.Width / (double)nGridTileSizeX );
				nNumTilesHigh = (int)( (double)oInventoryArea.Height / (double)nGridTileSizeY );
				oInventoryArea.Width = nNumTilesWide * nGridTileSizeX;
				oInventoryArea.Height = nNumTilesHigh * nGridTileSizeY;
			}
			else
			{
				int nInvBorder = 5;

				nNumTilesWide = 1;
				nNumTilesHigh = (int)( ( oInventoryArea.Height - nInvBorder ) / ( nGridTileSizeY + nInvBorder ) );
				//nNumTilesWide = (int)( (double)oInventoryArea.Width / (double)nGridTileSizeX );
				//nNumTilesHigh = (int)( (double)oInventoryArea.Height / (double)nGridTileSizeY );
				oInventoryArea.Width = nNumTilesWide * nGridTileSizeX;
				//oInventoryArea.Height = nNumTilesHigh * ( nGridTileSizeY + nInvBorder ) + nInvBorder;

				nGridTileSizeX = 120;
			}

			return( oInventoryArea );
		}
		private System.Drawing.Rectangle GetShipGridDetails( ref int nNumTilesWide,ref int nNumTilesHigh,
															 ref int nGridTileSizeX, ref int nGridTileSizeY )
		{
			int nBorder = 8;
			int nInventoryWidth = (int)( Globals.Inst().GameEngine.ScreenWidth * .25f );
			int nShipLeft = 0;
			int nShipBorderTop = 58;
			int nShipBorderBottom = 30;
			System.Drawing.Rectangle oShipArea = System.Drawing.Rectangle.Empty;
			System.Drawing.Rectangle oInventoryArea = System.Drawing.Rectangle.Empty;
			System.Drawing.Rectangle oInventoryRect = System.Drawing.Rectangle.Empty;


			//Find out where the inventory pane leaves off
			oInventoryRect = GetInvGridDetails( m_nCurrentInEditorDisplay,ref nNumTilesWide,ref nNumTilesHigh,ref nGridTileSizeX,ref nGridTileSizeY );
			nShipLeft = oInventoryRect.Right - GobConstants.m_cBORDER_GRAY_RIGHTSIZE;

			//Get our ship pane
			oShipArea = new Rectangle( 
				nShipLeft + GobConstants.m_cBORDER_GRAY_LEFTSIZE,
				nShipBorderTop + GobConstants.m_cBORDER_GRAY_TOPSIZE,
				Globals.Inst().GameEngine.ScreenWidth - nBorder - nShipLeft - GobConstants.m_cBORDER_GRAY_LEFTSIZE - GobConstants.m_cBORDER_GRAY_RIGHTSIZE,
				Globals.Inst().GameEngine.ScreenHeight - nShipBorderTop - nShipBorderBottom - GobConstants.m_cBORDER_GRAY_TOPSIZE - GobConstants.m_cBORDER_GRAY_BOTTOMSIZE );

			nGridTileSizeX = 25;//15;
			nGridTileSizeY = 25;//15;

			//Now shrink the area to make it a tight fit
			nNumTilesWide = (int)( (double)oShipArea.Width / (double)nGridTileSizeX );
			nNumTilesHigh = (int)( (double)oShipArea.Height / (double)nGridTileSizeY );
			//They have to be odd numbers so we can have a zero middle row
			if( ( nNumTilesWide % 2 ) == 0 )
			{
				nNumTilesWide--;
			}
			if( ( nNumTilesHigh % 2 ) == 0 )
			{
				nNumTilesHigh--;
			}
			oShipArea.Width = nNumTilesWide * nGridTileSizeX;
			oShipArea.Height = nNumTilesHigh * nGridTileSizeY;


			return( oShipArea );
		}
		private System.Drawing.Rectangle GetArrowRect( int nIndex,ref string sGraphicKey )
		{
			int nBorder = 8;
			int nDifference = 0;
			int nInvGridTileSizeX = 0, nInvGridTileSizeY = 0;
			int nNumTilesWide = 0, nNumTilesHigh = 0;
			System.Drawing.Rectangle oInventoryRect = Rectangle.Empty;
			System.Drawing.Rectangle oTargetRect = Rectangle.Empty;


			//Gather some inventory information
			oInventoryRect = GetInvGridDetails( m_nCurrentInEditorDisplay,ref nNumTilesWide,ref nNumTilesHigh,ref nInvGridTileSizeX,ref nInvGridTileSizeY );

			nDifference = (int)( ( oInventoryRect.Width - GobConstants.m_cEDITOR_ARROWWIDTH * 4 ) / 5.0 );
			oTargetRect = new Rectangle(
					nBorder + GobConstants.m_cBORDER_GRAY_LEFTSIZE + nDifference + 
						nIndex * ( GobConstants.m_cEDITOR_ARROWWIDTH + nDifference ),
					Globals.Inst().GameEngine.ScreenHeight - nBorder - GobConstants.m_cBORDER_GRAY_BOTTOMSIZE - 23 - 5,
					32,23 );

			//Get the graphic key
			if( nIndex == 0 )
			{
				sGraphicKey = GobConstants.m_cEDITOR_ARROW_DBLLEFT;
			}
			else if( nIndex == 1 )
			{
				sGraphicKey = GobConstants.m_cEDITOR_ARROW_LEFT;
			}
			else if( nIndex == 2 )
			{
				sGraphicKey = GobConstants.m_cEDITOR_ARROW_RIGHT;
			}
			else if( nIndex == 3 )
			{
				sGraphicKey = GobConstants.m_cEDITOR_ARROW_DBLRIGHT;
			}


			return( oTargetRect );
		}
		private System.Drawing.Rectangle GetTabRect( int nIndex,ref string sText )
		{
			int nActiveTabHeight = 22;
			int nInactiveTabHeight = 38;
			int nHeight = 0;
			int nTabStartLeft = 0;
			int nShipLeft = 0;
			System.Drawing.Rectangle oTargetRect = System.Drawing.Rectangle.Empty;
			System.Drawing.Rectangle oInventoryRect = System.Drawing.Rectangle.Empty;
			int nNumTilesWide = 0, nNumTilesHigh = 0;
			int nInvGridTileSizeX = 0, nInvGridTileSizeY = 0;


			//Get some preliminary information
			oInventoryRect = GetInvGridDetails( m_nCurrentInEditorDisplay,ref nNumTilesWide,ref nNumTilesHigh,ref nInvGridTileSizeX,ref nInvGridTileSizeY );
			nShipLeft = oInventoryRect.Right - GobConstants.m_cBORDER_GRAY_RIGHTSIZE;
			nTabStartLeft = nShipLeft + 80;

			//Get the tab data
			if( ( m_nCurrentInEditorDisplay == enumEditorObject.Chassis && nIndex == 0 ) ||
				( m_nCurrentInEditorDisplay == enumEditorObject.Modules && nIndex == 1 ) ||
				( m_nCurrentInEditorDisplay == enumEditorObject.Skins && nIndex == 2 ) )
			{ 
				nHeight = nActiveTabHeight; 
			}
			else
			{
				nHeight = nInactiveTabHeight; 
			}

			//Get our text
			if( nIndex == 0 )
			{
				sText = "CHASSIS";
			}
			else if( nIndex == 1 )
			{
				sText = "MODULES";
			}
			else if( nIndex == 2 )
			{
				sText = "   SKINS   ";
			}

			//Get our tab rectangle
			oTargetRect = new Rectangle( nTabStartLeft + 120 * nIndex,nHeight,120,42 );


			return( oTargetRect );
		}
		private RenderSettings GetBasicEditorRenderSettings( enumRenderType oRenderType )
		{
			RenderSettings oRenderSettings = new RenderSettings( 
						m_oAreaToDrawAt,Globals.Inst().OurShip,
						new Vector2(0,0),m_nCurrentZoom,oRenderType,
						enumEditorObject.Chassis,enumGameScreen.Editor,   
						0,System.Drawing.Color.White );
			return( oRenderSettings );
		}
		private void RenderGrid( string sTextureKey,
								 double nXStart,double nYStart,double nWidth,double nHeight,
								 long nGridWidth,long nGridHeight )
		{
			System.Drawing.Rectangle oSourceRect = new System.Drawing.Rectangle( 0,0,0,0 );
			System.Drawing.Rectangle oTargetRect = new System.Drawing.Rectangle( 0,0,0,0 );
			LoadedTexture oTexture = null;
			int nGridSizeX = 0, nGridSizeY = 0;
			int nGridStartX = 0, nGridStartY = 0;
			int nNumGridsWide = 0;
			int nNumGridsHigh = 0;


			oTexture = DSResourceManager.GetGlobalInstance().GetLoadedTexture( sTextureKey );

			nGridStartX = (int)nXStart;//( Globals.Inst().GameEngine.ScreenWidth * nPercentXStart );
			nGridStartY = (int)nYStart;//( Globals.Inst().GameEngine.ScreenHeight * nPercentYStart );
			nGridSizeX = (int)nGridWidth;//( (double)nWidth / (double)nGridWidth );//( ( Globals.Inst().GameEngine.ScreenWidth * nPercentXWidth ) / nGridWidth );
			nGridSizeY = (int)nGridHeight;//( (double)nHeight / (double)nGridHeight );//( ( Globals.Inst().GameEngine.ScreenHeight * nPercentYHeight ) / nGridHeight );
			nNumGridsWide = (int)( (double)nWidth / (double)nGridWidth );
			nNumGridsHigh = (int)( (double)nHeight / (double)nGridHeight );

			for( long nX=0 ; nX<nNumGridsWide ; nX+=3 )
			{
				if( nX + 3 >= nNumGridsWide )
				{
					oSourceRect.X = (int)( ( 3 - ( nNumGridsWide - nX ) ) * 50.0 ) - 1;
					oSourceRect.Width = (int)( oTexture.Size.X - oSourceRect.Left ) + 1;
					oTargetRect.X = (int)( nGridStartX + nX * nGridSizeX );
					oTargetRect.Width = (int)( ( nNumGridsWide - nX ) * nGridSizeX );
				}
				else if( nX == 0 )
				{
					oSourceRect.X = 0;
					oSourceRect.Width = (int)( oTexture.Size.X - 2 );
					oTargetRect.X = nGridStartX;
					oTargetRect.Width = (int)( nGridSizeX * 3.0 );
				}
				else
				{
					oSourceRect.X = 0;
					oSourceRect.Width = (int)oTexture.Size.X - 2;
					oTargetRect.X = (int)( nGridStartX + nX * nGridSizeX );
					oTargetRect.Width = (int)( 3.0 * nGridSizeX );
				}


				for( long nY=0 ; nY<nNumGridsHigh ; nY+=3 )
				{
					if( nY == 0 )
					{
						oSourceRect.Y = 0;
						oSourceRect.Height = (int)( oTexture.Size.Y - 2.0 );
						oTargetRect.Y = nGridStartY;
						oTargetRect.Height = (int)( nGridSizeY * 3.0 );
					}
					else if( nY + 3 >= nNumGridsHigh )
					{
						oSourceRect.Y = (int)( ( 3 - ( nNumGridsHigh - nY ) ) * 50.0 );
						oSourceRect.Height = (int)( oTexture.Size.Y - oSourceRect.Top );
						oTargetRect.Y = (int)( nGridStartY + nY * nGridSizeY );
						oTargetRect.Height = (int)( ( nNumGridsHigh - nY ) * nGridSizeY );
					}
					else
					{
						oSourceRect.Y = 0;
						oSourceRect.Height = (int)oTexture.Size.Y - 2;
						oTargetRect.Y = (int)( nGridStartY + nY * nGridSizeY );
						oTargetRect.Height = (int)( 3.0 * nGridSizeY );
					}

					//Draw our square
					Globals.Inst().GameEngine.RenderTexture2D(
						GraphicConstants.m_cGOB_GRAPHICS_GRID,oSourceRect, oTargetRect, 
						new Vector2( 0,0 ), 0, 0, false, System.Drawing.Color.White.ToArgb() );
				}
			}
		}

		#endregion
		#region Entity Management
		private void SpawnNewEntitys( Zone oZone,long nNumToAdd,Type oNewType )
		{
			double nVel = 100;
			Entity oNewEntity = null;


			for( int i=0 ; i<nNumToAdd ; i++ )
			{
				oNewEntity = (Entity)Activator.CreateInstance( oNewType,new object[]{} );
				oNewEntity.Vel = new Vector2(	(float)( DSMisc.GetRnd() * nVel - nVel / 2.0f ),
												(float)( DSMisc.GetRnd() * nVel - nVel / 2.0f ) );
				oNewEntity.Pos = new Vector2(
                    (float)(DSMisc.GetRnd() * this.Width - this.Width / 2.0),
                    (float)(DSMisc.GetRnd() * this.Height - this.Height / 2.0));

				//nMag = oNewEntity.Vel.Length() / 12.0;
				//oNewEntity.AngularMomentum = DSMisc.GetRnd() * nMag * 2 - nMag;

                oZone.AddEntity(this, oNewEntity, true);
			}
		}

		public void AddEntity( Entity oNewEntity,bool bNewEntityNeedsToBeResent )
		{
			if( m_oRemovedEntitys.ContainsKey( oNewEntity.PKey ) == false )
			{
                m_oZones.AddEntity(this, oNewEntity, bNewEntityNeedsToBeResent);
			}
		}
		public void RemoveEntity( Entity oDelEntity )
		{
			DSNetworkPacket oPacket = null;
            Zone oShipsZone = null;


if( oDelEntity == Globals.Inst().OurShip )
{
    oShipsZone = null;
}

            //In case its a way managed ship, remove it
			/*if( m_oWaveManager != null )
			{
				m_oWaveManager.RemoveEntity( oDelEntity );
			}*/

            //Actually remove them from the entity list in the zone
            oShipsZone = m_oZones[oDelEntity.MostUpToDateLoc.ZoneID.ToString()];
            oShipsZone.RemoveEntity(this,oDelEntity);

            //Now mark them in our "we've alreayd removed this joker" list
			oDelEntity.TotalElapsedTime = 0;
            if (m_oRemovedEntitys.ContainsKey(oDelEntity.PKey) == false)
            {
                m_oRemovedEntitys.Add(oDelEntity.PKey, oDelEntity);
            }
				
            //Clean it out of the super mass lize
			if( oDelEntity.SuperMass == true )
			{
                oShipsZone.RemoveEntity(this, oDelEntity);
			}

            //Finally, if we did actually remove them
			if( m_oEntitiesNeedingToBeSent_Full.ContainsKey( oDelEntity.PKey ) == true )
			{
				m_oEntitiesNeedingToBeSent_Full.Remove( oDelEntity.PKey );
			}
            if (m_oEntitiesNeedingToBeSent_Lite.ContainsKey(oDelEntity.PKey) == true)
			{
				m_oEntitiesNeedingToBeSent_Lite.Remove( oDelEntity.PKey );
			}

		    //Am I the host?  If not then we need to tell everyone else about this new entity
            if (Globals.Inst().IAmTheServer == true)
		    {
                oPacket = NetMsg.Pckt_RemoveEntity(oDelEntity);
			    SendMsgOnToAllPlayersInSession( oPacket );
		    }
		    else
		    {
                NetMsg.Send_RemoveEntity(Globals.Inst().Network, Globals.Inst().Network.PlayerWhoIsHost, oDelEntity);
		    }
		}

        public Entity GetEntity(string sEntityGuid)
        {
            return( m_oZones.GetEntity(sEntityGuid) );
        }
        public Entitys GetEntitysInMyZone(Entity oEntity)
        {
            return (this.Zones[oEntity.MostUpToDateLoc.ZoneID.ToString()].Entitys);
        }

        public void TransmitEntity(Entity oEntity,bool bFullUpdate)
        {
            if (bFullUpdate == true)
            {
                if (m_oEntitiesNeedingToBeSent_Full.ContainsKey(oEntity.PKey) == false)
                {
                    m_oEntitiesNeedingToBeSent_Full.Add(this, oEntity, false);
                }
            }
            else
            {
                if (m_oEntitiesNeedingToBeSent_Lite.ContainsKey(oEntity.PKey) == false)
                {
                    m_oEntitiesNeedingToBeSent_Lite.Add(this, oEntity, false);
                }
            }
        }
        public void ChangeZone(Entity oEntity)
        {
            m_oZones.ChangeZone(this,oEntity);
        }
		#endregion
		
		public void AddPlayer( DSNetworkPlayer oNewPlayer )
		{
            if (m_oAlertManager != null)
            {
                //Tell everyone hes gone
                m_oAlertManager.AddMessage("Player " + oNewPlayer.Name + " has joined the game.");
            }

			lock( m_oNetworkPlayers )
			{
				m_oNetworkPlayers.Add( oNewPlayer.SocketID,oNewPlayer );
			}
		}
		public void RemovePlayer( DSNetworkPlayer oPlayerToRemove )
		{
			Entity oLoopEntity = null;


            if (m_oAlertManager != null)
            {
                //Tell everyone hes gone
                m_oAlertManager.AddMessage("Player " + oPlayerToRemove.Name + " has left the game.");
            }

            foreach (Zone oLoopZone in this.Zones.Values)
            {
                for (int i = 0; i < oLoopZone.Entitys.Count; i++)
                {
                    oLoopEntity = oLoopZone.Entitys.Values[i];
                    if (oLoopEntity.OwnerSocketID == oPlayerToRemove.SocketID)
                    {
                        oLoopZone.RemoveEntity(this, oLoopEntity);
                    }
                }
            }

			lock( m_oNetworkPlayers )
			{
				m_oNetworkPlayers.Remove( oPlayerToRemove.SocketID );
			}
		}
		public string GetPlayerName( long nSocketID )
		{
			DSNetworkPlayer oNetPlayer = null;
			string sName = "";

			oNetPlayer = (DSNetworkPlayer)Globals.Inst().GameEngine.DirectPlay.GetPlayer( nSocketID );
            if (oNetPlayer != null)
            {
                sName = oNetPlayer.Name;
            }

			return( sName );
		}

        #region Create New Universe
		public ComplexEntity GetStarterShip()
		{
			ComplexEntity oOurShip = null;
			int nRnd = 0;


			//Setup the basics
			oOurShip = new ComplexEntity();
			if( Globals.Inst().GameEngine.DirectPlay.Me != null )
			{
				oOurShip.OwnerSocketID = Globals.Inst().GameEngine.DirectPlay.Me.SocketID;
			} 
			oOurShip.Pos = new Vector2( DSMisc.GetRnd( -2000,2000 ),DSMisc.GetRnd( -2000,2000 ) );
            oOurShip.Location.ZoneID = this.Zones.Values[0].ZoneID;
 
			//Now pick our ship type
			nRnd = DSMisc.GetRnd( 0,1 );
			if( nRnd == 0 )
			{
				Chassis oUrquanCone = null, oUrquanTunnel = null, oUrquanBlock = null, oUrquanLeftNacel = null, oUrquanRightNacel = null;

				oUrquanTunnel = Globals.AddChassis( oOurShip,1,-1,1 );
				Globals.AddModule( oOurShip,oUrquanTunnel,0,1,-1 );//Battery
				Globals.AddModule( oOurShip,oUrquanTunnel,typeof( Radar ),1,0 );

				oUrquanCone = Globals.AddChassis( oOurShip,0,-2,5 );
				Globals.AddModule( oOurShip,oUrquanCone,typeof( UrquanPlasmaLauncher ),1,1 );
				Globals.AddModule( oOurShip,oUrquanCone,typeof( XMissileLauncher ),4,0 );

				oUrquanBlock = Globals.AddChassis( oOurShip,2,-1,-2 );
				Globals.AddModule( oOurShip,oUrquanBlock,1,1,-1 );//Generator

				oUrquanLeftNacel = Globals.AddChassis( oOurShip,3,-4,3 );
				Globals.AddModule( oOurShip,oUrquanLeftNacel,2,1,-1 );//AttitudeThruster
				Globals.AddModule( oOurShip,oUrquanLeftNacel,4,1,-6 );//Thruster

				oUrquanRightNacel = Globals.AddChassis( oOurShip,4,2,3 );
				Globals.AddModule( oOurShip,oUrquanRightNacel,2,1,-1 );//AttitudeThruster
				Globals.AddModule( oOurShip,oUrquanRightNacel,4,1,-6 );//Thruster
			}
			else if( nRnd == 1 )
			{
				Chassis oSpathiRed = null, oSpahiGreen = null, oSpathiPurple = null, oSpathiBlue = null, oSpathiYellow = null;
                
				oSpathiRed = Globals.AddChassis( oOurShip,6,0,0 );
				Globals.AddModule( oOurShip,oSpathiRed,typeof( SpathiBUTTLauncher ),0,-1 );
				Globals.AddModule( oOurShip,oSpathiRed,typeof( SpathiPlasmaPelletLauncher ),0,1 );

				oSpahiGreen = Globals.AddChassis( oOurShip,7,-2,2 );
				Globals.AddModule( oOurShip,oSpahiGreen,3,1,-1 );//Spathi_Module_Pile

				oSpathiPurple = Globals.AddChassis( oOurShip,8,1,1 );

				oSpathiBlue = Globals.AddChassis( oOurShip,9,1,-1 );
				Globals.AddModule( oOurShip,oSpathiBlue,typeof( Radar ),1,-1 );

				oSpathiYellow = Globals.AddChassis( oOurShip,10,-1,-1 );
				Globals.AddModule( oOurShip,oSpathiYellow,0,0,-1 );//Battery

				oSpathiRed = Globals.AddChassis( oOurShip,11,0,-1 );				
				Globals.AddModule( oOurShip,oSpathiRed,5,0,-2 );//Spathi_Module_InertiaDrive
			}
			

			return( oOurShip );
		}

        public void SpawnNewUniverse()
        {
            Zones oClosestSystems = null;
            Zone oSystem = null;
            double nAngle = 0, nDist = 0;
            int nTemp = 0, nSystems = 0;


            //Start by skattering a random assortment of stars
            nSystems = DSMisc.GetRnd(5, 20);
            for (int i = 1; i <= nSystems; i++)
            {
                //Create a system and place it
                oSystem = new Zone();
                nAngle = DSMisc.GetRnd() * Math.PI * 2.0;
                nDist = DSMisc.GetRnd() * 300.0;
                oSystem.X = Math.Cos(nAngle) * nDist;
                oSystem.Y = Math.Sin(nAngle) * nDist;
                oSystem.Name = "Zone 1-" + i.ToString();

                //Fill it
                SpawnNewEntitys(oSystem, 5, typeof(Asteroid));
                SpawnNewEntitys(oSystem, 5, typeof(RedAsteroid));
                nTemp = DSMisc.GetRnd(0, 4);
                if (nTemp == 0)
                {
                    SpawnNewEntitys(oSystem, 5, typeof(Vux));
                }
                else if (nTemp == 1)
                {
                    SpawnNewEntitys(oSystem, 5, typeof(Shagot));
                }
                SpawnNewEntitys(oSystem, 1, typeof(Shagot));

                //AddBecons(oSystem);

                m_oZones.Add(oSystem);
            }

            //Now go through every system and give it a handful of portals to connect it
            foreach (Zone oLoopZone in m_oZones.Values)
            {
                if (DSMisc.GetRnd(0, 1) == 1)
                {
                    //Find the closest systms we want to link to
                    oClosestSystems = m_oZones.GetClosestZones(oLoopZone, 1);
                    foreach (Zone oLoopClosestZone in oClosestSystems.Values)
                    {
                        LinkTwoZones(oLoopZone, oLoopClosestZone);
                    }
                }
            }

            //Find any un-portaled zones and add a portal
            foreach (Zone oLoopZone in m_oZones.Values)
            {
                if (oLoopZone.GetPortalCount() == 0)
                {
                    nTemp = DSMisc.GetRnd(1, 3);
                    //Find the closest systms we want to link to
                    oClosestSystems = m_oZones.GetClosestZones(oLoopZone, nTemp);
                    foreach (Zone oLoopClosestZone in oClosestSystems.Values)
                    {
                        LinkTwoZones(oLoopZone, oLoopClosestZone);
                    }
                }
            }
        }
        private void LinkTwoZones(Zone oZone1, Zone oZone2)
        {
            Portal oPortal1 = null, oPortal2 = null;


            //Add a portal connection
            oPortal1 = new Portal();
            oPortal1.Location = new Location();
            oPortal1.Location.Pos = new Vector2((float)DSMisc.GetRnd(-this.Width / 2.0, this.Width / 2.0),
                                                (float)DSMisc.GetRnd(-this.Height / 2.0, this.Height / 2.0));

            //And connect it
            oPortal2 = new Portal();
            oPortal2.Location = new Location();
            oPortal2.Location.Pos = new Vector2((float)DSMisc.GetRnd(-this.Width / 2.0, this.Width / 2.0),
                                                (float)DSMisc.GetRnd(-this.Height / 2.0, this.Height / 2.0));

            oPortal1.LinkedPortalEntityID = oPortal2.PKeyObject;
            oPortal2.LinkedPortalEntityID = oPortal1.PKeyObject;

            oZone1.AddEntity(this, oPortal1, false);
            oZone2.AddEntity(this, oPortal2, false);
        }
        private void AddBecons(Zone oZone)
        {
            Becon oNewBecon = null;
            int nNumber = 15;
            float nXInterv = (float)this.Width / nNumber;
            float nYInterv = (float)this.Height / nNumber;


            for (int nX = 0; nX <= nNumber; nX++)
            {
                oNewBecon = new Becon();
                oNewBecon.Pos = new Vector2(-(float)this.Width / 2f + nX * nXInterv, -(float)this.Width / 2f);
                oZone.AddEntity(this,oNewBecon,false);

                oNewBecon = new Becon();
                oNewBecon.Pos = new Vector2(-(float)this.Width / 2f + nX * nXInterv, +(float)this.Width / 2f);
                oZone.AddEntity(this, oNewBecon, false);
            }

            for (int nY = 1; nY < nNumber; nY++)
            {
                oNewBecon = new Becon();
                oNewBecon.Pos = new Vector2(-(float)this.Height / 2f, -(float)this.Height / 2f + nY * nYInterv);
                oZone.AddEntity(this, oNewBecon, false);

                oNewBecon = new Becon();
                oNewBecon.Pos = new Vector2(+(float)this.Height / 2f, -(float)this.Height / 2f + nY * nYInterv);
                oZone.AddEntity(this, oNewBecon, false);
            }
        }
        #endregion

        public string Serialize()
		{
			string sRetVal = "";
			DSSerialize oSerialize = new DSSerialize();
			//Entity oLoopEntity = null;


			//Now save our data
			oSerialize.Set( 0,m_sSessionName );
			/*oSerialize.SetList( 1 );
			foreach( Zone oLoopZone in m_oZones.Values )
			{
                oSerialize.SetListItem(1, oLoopZone.Serialize(this));
			}*/
			oSerialize.Set( 2,m_bDebug_Pause );
			//oSerialize.Set( 3,m_oWaveManager.CurrentWave );
            oSerialize.Set( 4,m_sGUID );

			sRetVal = oSerialize.Serialize(1);


			return( sRetVal );
		}
		public void DeSerialize( string sSession )
		{
			DSSerialize oSerialize = new DSSerialize();
			//ArrayList oZones = null;
			//Zone oNewZone = null, oLoopZone = null;
            int nVersion = 0;


			oSerialize.DeSerialize( sSession,ref nVersion );

			m_sSessionName = oSerialize.GetString( 0 );
             
            /*oZones = oSerialize.GetList(1);
			//Walk the entitys and update them
            foreach( string sLoopZoneSerialized in oZones )
			{
                oNewZone = new Zone();
                oNewZone.DeSerialize(this, sLoopZoneSerialized);

				//Do we have this entity?
                if (m_oZones.ContainsKey(oNewZone.PKey) == true )
                {
                    oLoopZone = m_oZones[oNewZone.PKey];
                    oLoopZone.DeSerialize(this, sLoopZoneSerialized);
                }
                else 
                {
                    m_oZones.Add(oNewZone);
                }
			}*/

			m_bDebug_Pause = oSerialize.GetBool( 2 );
			//m_oWaveManager.CurrentWave = oSerialize.GetLong( 3 );
            if (nVersion >= 1)
            {
                m_sGUID = oSerialize.GetString(4);
            }
		}

		public Vector2 ConvertWorldPtToScreenPt( RenderSettings oRenderSettings,Vector2 vWorldPt )
		{
			Vector2 vScreenPtCenterScreen = Vector2.Empty;
			Vector2 vWorldPtCenterView = Vector2.Empty;
			Vector2 vScreenPt = Vector2.Empty;  


			//Don't forget, we center on a certain offset 
			vWorldPtCenterView = new Vector2( oRenderSettings.EntityToCenterOn.Pos.X + oRenderSettings.EntityOffset.X,
											  oRenderSettings.EntityToCenterOn.Pos.Y + oRenderSettings.EntityOffset.Y );
			 
			//Get the center of the screen
			vScreenPtCenterScreen = new Vector2( oRenderSettings.AreaToDrawAt.Left + oRenderSettings.AreaToDrawAt.Width / 2f,
												 //- GraphicConstants.m_cGRID_WIDTH / 2f, 
												 oRenderSettings.AreaToDrawAt.Top + oRenderSettings.AreaToDrawAt.Height / 2f );
												 //- GraphicConstants.m_cGRID_HEIGHT / 2f );
			//Now where is THIS point in screen coordinates
			vScreenPt = new Vector2( 
					(float)( vScreenPtCenterScreen.X + ( vWorldPt.X - vWorldPtCenterView.X ) * oRenderSettings.ZoomLevel ),
					(float)( vScreenPtCenterScreen.Y + ( vWorldPt.Y - vWorldPtCenterView.Y ) * oRenderSettings.ZoomLevel ) );


			return( vScreenPt );
		}
		public Vector2 ConvertScreenPtToWorldPt (System.Drawing.Rectangle oAreaToDrawAt,Entity oEntityToCenterOn,Vector2 vEntityOffset,Vector2 vScreenPt,double nZoomLevel )
		{
			Vector2 vScreenPtCenterScreen = Vector2.Empty;
			Vector2 vWorldPtCenterView = Vector2.Empty;
			Vector2 vWorldPt = Vector2.Empty; 


			//Don't forget, we center on a certain offset 
			vWorldPtCenterView = new Vector2( oEntityToCenterOn.Pos.X + vEntityOffset.X,oEntityToCenterOn.Pos.Y + vEntityOffset.Y );

			//Get the center of the screen
			vScreenPtCenterScreen = new Vector2( oAreaToDrawAt.Left + oAreaToDrawAt.Width / 2f
												 - GraphicConstants.m_cGRID_WIDTH / 2f, 
												 oAreaToDrawAt.Top + oAreaToDrawAt.Height / 2f
												 - GraphicConstants.m_cGRID_HEIGHT / 2f );

			//Now where is THIS point in world coordinates
			vWorldPt = new Vector2( 
				(float)( ( ( vScreenPt.X - vScreenPtCenterScreen.X ) / nZoomLevel ) + vWorldPtCenterView.X ),
				(float)( ( ( vScreenPtCenterScreen.Y - vScreenPt.Y ) / nZoomLevel ) + vWorldPtCenterView.Y ) );


			return( vWorldPt );
		}

		//Boolean indicates true if message should be sent on to other players
		public bool AddChatMsg( DSNetworkPlayer oSendingPlayer,string sMessage )
		{
			bool bSendOnToServer = true;


			bSendOnToServer = CheckForCheatCodes( sMessage );

			if( m_oAlertManager != null )
			{
				if( oSendingPlayer != null )
				{
					m_oAlertManager.AddMessage( oSendingPlayer.Name + ": " + sMessage );
                    Globals.PlaySound(SoundConstants.m_cNEWMSG,null);
				}
				else
				{
					m_oAlertManager.AddMessage( sMessage );
				}
			}


			return( bSendOnToServer );
		}
		public void SendMsgOnToAllPlayersInSession( DSNetworkPacket oPacket )
		{
			DSNetworkPlayer oLoopPlayer = null;
			DSSortedList oTempList = null;


			lock( m_oNetworkPlayers )
			{
				oTempList = m_oNetworkPlayers.Clone();
			}
			//Forward the message to anyone not in a session
			for( int i=0 ; i<oTempList.Count ; i++ )
			{
				oLoopPlayer = (DSNetworkPlayer)oTempList.GetByIndex( i );
				Globals.Inst().GameEngine.DirectPlay.SendMsg( oLoopPlayer,oPacket );
			}	
		}

		//Boolean indicates true if message should be sent on to other players
		public bool CheckForCheatCodes( string sMessage )
		{
			ArrayList oItemsCreated = null;
			bool bSendOnToServer = true;


			if( sMessage == "+Debug" )
			{
				bSendOnToServer = false;
				m_bDebug_Debug = !m_bDebug_Debug;
			}
			else if( sMessage == "+FPS" )
			{
				bSendOnToServer = false;
				m_bDebug_FPS = !m_bDebug_FPS;
			}
			else if( sMessage == "+Locs" )
			{
				bSendOnToServer = false;
				m_bDebug_Locs = !m_bDebug_Locs;
			}
			else if( sMessage == "+Collide" )
			{
				bSendOnToServer = false;
				m_bDebug_Collide = !m_bDebug_Collide;
			}
			else if( sMessage == "+NoAI" )
			{
				bSendOnToServer = true;
				m_bDebug_NoAI = !m_bDebug_NoAI;
			}
			else if( sMessage == "+Pause" )
			{
				bSendOnToServer = true;
				m_bDebug_Pause = !m_bDebug_Pause;
			}
			else if( sMessage == "+Respawn" )
			{
				bSendOnToServer = false;

				//Kill our old ship
				Globals.Inst().OurShip.OwnerSocketID = -1;
				Globals.Inst().OurShip.CanPickUpItems = false;
				Globals.Inst().OurShip.StartFadeout( 3.0 );
				NetMsg.Send_EntityUpdate( Globals.Inst().GameEngine.DirectPlay,
					Globals.Inst().GameEngine.DirectPlay.PlayerWhoIsHost,this,Globals.Inst().OurShip );

				//Send a new ship
				ComplexEntity oOurShip = GetStarterShip();
                Globals.Inst().MyZone.AddEntity( this,oOurShip,true );
				Globals.Inst().OurShip = oOurShip;
				Globals.Inst().Profile.OurShip = oOurShip;
				NetMsg.Send_EntityUpdate( Globals.Inst().GameEngine.DirectPlay,
					Globals.Inst().GameEngine.DirectPlay.PlayerWhoIsHost,this,oOurShip );

				AddChatMsg( null,"You have died!  Respawning." );
			}
			else if( sMessage.Length >= 8 && sMessage.Substring( 0,8 ) == "+AddExp " )
			{
                long nExp = 0;

				bSendOnToServer = false;
                nExp = DSMisc.TypeUtils.GetSafeLng(sMessage.Substring(8));

                if (nExp != 0)
                {
                    GiveExpToEntity(Globals.Inst().OurShip, nExp);
                    NetMsg.Send_EntityReceivesEXP(Globals.Inst().GameEngine.DirectPlay, Globals.Inst().OurShip, nExp);
                }
			}
			else if( sMessage.Length >= 5 && sMessage.Substring( 0,5 ) == "+HUD " )
			{
				long nNum = 0;
				string sTemp = "";

				bSendOnToServer = false;

				sTemp = sMessage.Substring( 5 );
				if( DSMisc.IsNumber( sTemp ) == true )
				{
					nNum = Convert.ToInt32( sTemp );
					Globals.Inst().OurShip.BaseHUDLevel = (int)nNum;
				}
				else
				{
					AddChatMsg( null,"<" + sTemp + "> is not a valid number." );
				}				
			}
			else if( sMessage.Length >= 11 && sMessage.Substring( 0,11 ) == "+AddShagot " )
			{
				long nNum = 0;
				string sTemp = "";

				bSendOnToServer = true;

				if( Globals.Inst().IAmTheServer == true )
				{
					sTemp = sMessage.Substring( 11 );
					if( DSMisc.IsNumber( sTemp ) == true )
					{
						nNum = Convert.ToInt32( sTemp );
						if( nNum >= 1 && nNum <= 10 )
						{
						    SpawnNewEntitys( this.Zones.Values[0],nNum,typeof( Shagot ) ); 
						}
						else
						{
							AddChatMsg( null,"You can only add between 1 and 10 AIs.  You enetered <" + nNum.ToString() + ">" );
						}
					}
					else
					{
						AddChatMsg( null,"<" + sTemp + "> is not a valid number." );
					}
				}
			}
			else if( sMessage.Length >= 8 && sMessage.Substring( 0,8 ) == "+AddVux " )
			{
				long nNum = 0;
				string sTemp = "";

				bSendOnToServer = true;

				if( Globals.Inst().IAmTheServer == true )
				{
					sTemp = sMessage.Substring( 8 );
					if( DSMisc.IsNumber( sTemp ) == true )
					{
						nNum = Convert.ToInt32( sTemp );
						if( nNum >= 1 && nNum <= 10 )
						{
                            SpawnNewEntitys(this.Zones.Values[0], nNum, typeof(Vux)); 
						}
						else
						{
							AddChatMsg( null,"You can only add between 1 and 10 AIs.  You enetered <" + nNum.ToString() + ">" );
						}
					}
					else
					{
						AddChatMsg( null,"<" + sTemp + "> is not a valid number." );
					}
				}
			}
			else if( sMessage.Length >= 8 && sMessage.Substring( 0,8 ) == "+AddAst " )
			{
				long nNum = 0;
				string sTemp = "";

				bSendOnToServer = false;

				sTemp = sMessage.Substring( 8 );
				if( DSMisc.IsNumber( sTemp ) == true )
				{
					nNum = Convert.ToInt32( sTemp );
					if( nNum >= 1 && nNum <= 400 )
					{
						bSendOnToServer = true;
						if( Globals.Inst().IAmTheServer == true )
						{
                            SpawnNewEntitys(this.Zones.Values[0], nNum, typeof(Asteroid)); 
						}
					}
					else
					{
						AddChatMsg( null,"You can only add between 1 and 400 Asteroids.  You enetered <" + nNum.ToString() + ">" );
					}
				}
				else
				{
					AddChatMsg( null,"<" + sTemp + "> is not a valid number." );
				}
			}
            else if (sMessage.Length >= 8 && sMessage.Substring(0, 8) == "+AddRed ")
            {
                long nNum = 0;
                string sTemp = "";

                bSendOnToServer = false;

                sTemp = sMessage.Substring(8);
                if (DSMisc.IsNumber(sTemp) == true)
                {
                    nNum = Convert.ToInt32(sTemp);
                    if (nNum >= 1 && nNum <= 400)
                    {
                        bSendOnToServer = true;
                        if (Globals.Inst().IAmTheServer == true)
                        {
                            SpawnNewEntitys(this.Zones.Values[0], nNum, typeof(RedAsteroid));
                        }
                    }
                    else
                    {
                        AddChatMsg(null, "You can only add between 1 and 400 RedAsteroids.  You enetered <" + nNum.ToString() + ">");
                    }
                }
                else
                {
                    AddChatMsg(null, "<" + sTemp + "> is not a valid number.");
                }
            }			
			else if( sMessage == "+Loot" )
			{
				double nAngle = 0;
				double nDist = 0;

				bSendOnToServer = false;
				for( int i=0 ; i<10 ; i++ )
				{
					nAngle = DSMisc.GetRnd() * Math.PI * 2;
					nDist = ( DSMisc.GetRnd() * 100 - 50 ) + 350;

					CreateFloatingLoot( Globals.Inst().MyZone.ZoneID.ToString(),
                        new Vector2( (float)( Globals.Inst().OurShip.Pos.X + Math.Cos( nAngle ) * nDist ),
						(float)( Globals.Inst().OurShip.Pos.Y + Math.Sin( nAngle ) * nDist ) ),
						LootConstants.m_cALWAYSGETLOOT );
				}
			}
			else if( sMessage == "+Loot2" )
			{
				bSendOnToServer = false;

				for( int i=0 ; i<10 ; i++ )
				{
					oItemsCreated = GenerateItem( LootConstants.m_cALWAYSGETLOOT );
					foreach( Item oLoopItem in oItemsCreated )
					{
                        Globals.Inst().Profile.AddItem(oLoopItem);
					}
				}
			}
			else if( sMessage == "+IWin" )
			{
				bSendOnToServer = true;
				/*if( Globals.Inst().IAmTheServer == true )
				{
					m_oWaveManager.KillAllWaveEntitys();
				}*/
			}
			else if( sMessage.Length >= 10 && sMessage.Substring( 0,10 ) == "+DamageMe " )
			{
				bSendOnToServer = false;
				Chassis oLoopChassis = null;
				double nDamage = DSMisc.TypeUtils.GetSafeDbl( sMessage.Substring( 10 ) );
				for( int nChassisIdx=0 ; nChassisIdx<Globals.Inst().OurShip.Chasses.Count ; nChassisIdx++ )
				{
					oLoopChassis = (Chassis)Globals.Inst().OurShip.Chasses.GetByIndex( nChassisIdx );
                    oLoopChassis.DealDamage(this, nDamage, new Region());
				}
			}
			else if( sMessage == "+KillAll" )
			{
                bSendOnToServer = true;
                foreach (Zone oLoopZone in m_oZones.Values)
                {
                    foreach (Entity oLoopEntity in oLoopZone.Entitys.Values)
                    {
                        if (oLoopEntity.OwnerSocketID == MiscConstants.m_cNOSOCKETIDASSIGNED &&
                            oLoopEntity.SuperMass == false &&
                            oLoopEntity.GetType() != typeof( Portal ) )
                        {
                            oLoopEntity.IsDead = true;
                            oLoopEntity.StartFadeout(2);
                        }
                    }
                }
			}
			else if( sMessage == "+WaveOff" )
			{
				bSendOnToServer = true;
				//m_oWaveManager.Active = false;
			}
			else if( sMessage == "+WaveOn" )
			{
				bSendOnToServer = true;
				//m_oWaveManager.Active = true;
			}
			else if( sMessage == "+StopAll" )
			{
				bSendOnToServer = true;
                foreach (Zone oLoopZone in m_oZones.Values)
                {
                    foreach (Entity oLoopEntity in oLoopZone.Entitys.Values)
                    {
                        oLoopEntity.Vel = new Vector2(0, 0);
                    }
                }
			}
			else if( sMessage == "+WipeMeOut" )
			{
				bSendOnToServer = false;

				Globals.Inst().Profile.UnassignedModules.Clear();
				Globals.Inst().Profile.UnassignedChassis.Clear();
			}


			return( bSendOnToServer );
		}
		public void CreateFloatingLoot( string sZoneID,Vector2 vPos,int nLootID )
		{
            Zone oZone = null;
			ArrayList oItemsCreated = null;
			FloatingLoot oNewFloatingLoot = null;


            oZone = m_oZones[sZoneID];

            oItemsCreated = GenerateItem(nLootID);
			foreach( Item oLoopItem in oItemsCreated )
			{
				oNewFloatingLoot = new FloatingLoot();
				oNewFloatingLoot.ItemToBeReceived = oLoopItem;
				oNewFloatingLoot.Pos = new Vector2( vPos.X,vPos.Y );

                oZone.AddEntity(this,oNewFloatingLoot, true);
			}
		}
		public ArrayList GenerateItem( int nLootID )
		{
			DSGobTable oChassisTable = null;
			DSGobTable oModuleTable = null;
			DSGobTable oLootTable = null;
			//DSGobTable oSkinsTable = null;
			DSGobTable oTraitsTable = null;
			ArrayList oItemsCreated = new ArrayList();
			Item oNewItem = null;
			ItemSpecialTrait oNewTrait = null;
			GenericChassis oGenericChassis = null;
			GenericModule oGenericModule = null;
            bool bFound = false;
			int nRow = 0;
			long nRndInt = 0;
			double nMinValue = 0, nMaxValue = 0;
			double nRndDbl = 0;
			double nPrcntChassis = 0, nPrcntModule = 0, nPrcntSkin = 0;
			double nPrcntLegacy = 0, nPrcntSuperCharged = 0, nPrcntCharged = 0;
			//double nPrcntAdvanced = 0, nPrcntExpert = 0;
			double nChanceForMoreLoot = 0;


			try
			{
				//Normally the loot item we'd use would be random, but for now just use the first one we find
				oLootTable = DSResourceManager.GetGlobalInstance().GetGobTable( GobConstants.m_cTABLE_LOOT );
				nRow = oLootTable.FindRow( GobConstants.m_cTABLE_LOOTID,nLootID );
				nChanceForMoreLoot = (double)oLootTable.GetData( GobConstants.m_cTABLE_PRCNT_MORELOOT,nRow );

                do
				{
					#region Pick a type
					//What are our chances?
					nPrcntChassis = (double)oLootTable.GetData( GobConstants.m_cTABLE_PRCNT_CHASSIS,nRow );
					nPrcntModule = (double)oLootTable.GetData( GobConstants.m_cTABLE_PRCNT_MODULE,nRow );
					nPrcntSkin = (double)oLootTable.GetData( GobConstants.m_cTABLE_PRCNT_SKIN,nRow );
					oNewItem = null;

					//////////////////////////////////////////////////////////////////////
					//Chassis
					//////////////////////////////////////////////////////////////////////
					nRndDbl = DSMisc.GetRnd();
					if( nRndDbl < nPrcntChassis )
					{
						//Chassis
						oChassisTable = DSResourceManager.GetGlobalInstance().GetGobTable( GobConstants.m_cTABLE_CHASSIS );
						nRndInt = DSMisc.GetRnd( 0,oChassisTable.RowCount-1 );
						oGenericChassis = new GenericChassis( Globals.Inst().OurShip,(int)nRndInt );
						oNewItem = oGenericChassis;
					}
					//////////////////////////////////////////////////////////////////////
					//Modules
					//////////////////////////////////////////////////////////////////////
					else if( nRndDbl >= nPrcntChassis && nRndDbl < nPrcntModule + nPrcntChassis )
					{
						nRndInt = DSMisc.GetRnd( 0,1 );
						if( nRndInt == 0 )
						{
							//Module
							oModuleTable = DSResourceManager.GetGlobalInstance().GetGobTable( GobConstants.m_cTABLE_MODULE );
							nRndInt = DSMisc.GetRnd( 0,oModuleTable.RowCount-1 );
							oGenericModule = new GenericModule( Globals.Inst().OurShip,(int)nRndInt );
							oNewItem = oGenericModule;
						}
						else
						{
							//Module
							nRndInt = DSMisc.GetRnd( 0,10 );
							//if( nRndInt == 0 )	   { oNewItem = new Battery( Globals.Inst().OurShip ); }
							//else if( nRndInt == 5 ){ oNewItem = new AttitudeThruster( Globals.Inst().OurShip ); }
							//else if( nRndInt == 6 ){ oNewItem = new Generator( Globals.Inst().OurShip ); }
							//else if( nRndInt == 9 ){ oNewItem = new ScatterLauncher( Globals.Inst().OurShip ); }	
							//else if( nRndInt == 16 ){ oNewItem = new Spathi_Module_Pile( Globals.Inst().OurShip ); }
							//else if( nRndInt == 12 ){ oNewItem = new Spathi_Module_InertiaDrive( Globals.Inst().OurShip ); }
							//else if( nRndInt == 0 ){ oNewItem = new Thruster( Globals.Inst().OurShip ); }
								 if( nRndInt == 0 ){ oNewItem = new XMissileLauncher( Globals.Inst().OurShip ); }
							else if( nRndInt == 1 ){ oNewItem = new UrquanPlasmaLauncher( Globals.Inst().OurShip ); }
							else if( nRndInt == 2 ){ oNewItem = new Radar( Globals.Inst().OurShip ); }
							else if( nRndInt == 3 ){ oNewItem = new CloakingDevice( Globals.Inst().OurShip ); }
							else if( nRndInt == 4 ){ oNewItem = new EntrophyShield( Globals.Inst().OurShip ); }
							else if( nRndInt == 5 ){ oNewItem = new PointDefensePlasma( Globals.Inst().OurShip ); }	
							else if( nRndInt == 6 ){ oNewItem = new EtherialFin( Globals.Inst().OurShip ); }
							else if( nRndInt == 7 ){ oNewItem = new LimpitLauncher( Globals.Inst().OurShip ); }
							else if( nRndInt == 8 ){ oNewItem = new VuxLazer( Globals.Inst().OurShip ); }
							else if( nRndInt == 9 ){ oNewItem = new SpathiPlasmaPelletLauncher( Globals.Inst().OurShip ); }
							else if( nRndInt == 10 ){ oNewItem = new SpathiBUTTLauncher( Globals.Inst().OurShip ); }
							else
							{
								throw new System.Exception( "Unable to find module to create." );
							}
						}
					}
					//////////////////////////////////////////////////////////////////////
					//Skins
					//////////////////////////////////////////////////////////////////////
					else
					{
						break;
						/*oSkinsTable = DSResourceManager.GetGlobalInstance().GetGobTable( GobConstants.m_cTABLE_SKINS );

						oNewItem = new Skin( Globals.Inst().OurShip );
						nRndInt = DSMisc.GetRnd( 0,oSkinsTable.RowCount-1 );
						((Skin)oNewItem).DBSkinID = (int)oSkinsTable.GetData( GobConstants.m_cCLMN_SKINID,nRndInt );*/
					}
					#endregion

					#region Pick class 
					//What are our chances?
					nPrcntLegacy = (double)oLootTable.GetData( GobConstants.m_cTABLE_PRCNT_LEGACY,nRow );
					nPrcntSuperCharged = (double)oLootTable.GetData( GobConstants.m_cTABLE_PRCNT_SUPERCHARGED,nRow );
					nPrcntCharged = (double)oLootTable.GetData( GobConstants.m_cTABLE_PRCNT_CHARGED,nRow );
					
					//What is its class?  Aka how rare is it?
					nRndDbl = DSMisc.GetRnd();
					if( nRndDbl < nPrcntLegacy )
					{
						oNewItem.ItemClass = enumItemClass.Legacy;
					}
					else if( nRndDbl > nPrcntLegacy && nRndDbl < nPrcntLegacy + nPrcntSuperCharged )
					{
						oNewItem.ItemClass = enumItemClass.SuperCharged;
					}
					else if( nRndDbl > nPrcntLegacy + nPrcntSuperCharged && nRndDbl < nPrcntLegacy + nPrcntSuperCharged + nPrcntCharged )
					{
						oNewItem.ItemClass = enumItemClass.Charged;
					}
					else
					{
						oNewItem.ItemClass = enumItemClass.Routine;
					}
					#endregion

					#region Pick level
					/*nPrcntAdvanced = (double)oLootTable.GetData( GobConstants.m_cTABLE_PRCNT_ADVANCED,nRow );
					nPrcntExpert = (double)oLootTable.GetData( GobConstants.m_cTABLE_PRCNT_EXPERT,nRow );

					//Now pick a level
					nRndDbl = DSMisc.GetRnd();
					if( nRndDbl < nPrcntAdvanced )
					{
						oNewItem.ItemLevel = enumItemLevel.Advanced;
					}
					else if( nRndDbl > nPrcntAdvanced && nRndDbl < nPrcntAdvanced + nPrcntExpert )
					{
						oNewItem.ItemLevel = enumItemLevel.Expert;
					}
					else
					{
						oNewItem.ItemLevel = enumItemLevel.Normal;
					}*/

					//Now pick a level
					/*if( m_oWaveManager.CurrentWave <= m_cWAVE_NORMAL )
					{*/
						oNewItem.ItemLevel = enumItemLevel.Normal;
					/*}
					else if( m_oWaveManager.CurrentWave <= m_cWAVE_ADVANCED )
					{
						oNewItem.ItemLevel = enumItemLevel.Advanced;
					}
					else
					{
						oNewItem.ItemLevel = enumItemLevel.Expert;
					}*/
					#endregion

					#region Pick special item traits
					//////////////////////////////////////////////////////////////////////
					//Now generate special item traits
					//////////////////////////////////////////////////////////////////////
					if( oNewItem.GetType() != typeof( Skin ) )
					{
						//Now does it get any special traits?
						if( oNewItem.ItemClass != enumItemClass.Routine )
						{
							oTraitsTable = DSResourceManager.GetGlobalInstance().GetGobTable( GobConstants.m_cTABLE_SPECIALTRAITS );

							do 
							{
								//Generate a random trait
								nRndInt = DSMisc.GetRnd( 0,oTraitsTable.RowCount-1 );

								oNewTrait = new ItemSpecialTrait();
								oNewTrait.SpecialTraitID = (int)nRndInt;
								oNewTrait.SpecialTraitEnum = (enumEntProperties)(int)oTraitsTable.GetData( GobConstants.m_cCLMN_SPECIALTRAITID,nRndInt );

								nMinValue = (double)oTraitsTable.GetData( GobConstants.m_cCLMN_MINVALUE,nRndInt );
								nMaxValue = (double)oTraitsTable.GetData( GobConstants.m_cCLMN_MAXVALUE,nRndInt );
								oNewTrait.Value = DSMisc.GetRnd( nMinValue,nMaxValue );

                                //Only add this special trait if we don't have it already
                                bFound = false;
                                foreach (ItemSpecialTrait oLoopTrait in oNewItem.SpecialTraits)
                                {
                                    if (oLoopTrait.SpecialTraitID == oNewTrait.SpecialTraitID)
                                    {
                                        bFound = true;
                                        break;
                                    }
                                }
                                if (bFound == false)
                                {
                                    oNewItem.SpecialTraits.Add(oNewTrait);
                                }
							}
							while( DSMisc.GetRnd() < .2 );
						}
					}
					#endregion

					//This lets the item do anything special it wants to do, such as react to its level and such.
					oNewItem.CreatedAsNewItem();
					oItemsCreated.Add( oNewItem );
				}
				while( DSMisc.GetRnd() < nChanceForMoreLoot );
			}
			catch( System.Exception oEx )
			{
			 	DSMisc.ShowErrors( oEx );
			}


			return( oItemsCreated );
		}
		public void GiveExpToEntity( Entity oEntity,long nAmountOfEXP )
		{
			long nPostExpLevelID = 0;
			long nPreExpLevelID = 0;
			long nNextLevelEXP = 0;
			ArrayList oTraits = null;


			//Record things to see if we went up a level
			nPreExpLevelID = oEntity.LevelID;
			oEntity.EXP += nAmountOfEXP;
			Session.GetLevelInfo( oEntity.EXP,ref nPostExpLevelID,ref nNextLevelEXP,ref oTraits );

			AddRollingText( oEntity.Pos,
				new Vector2( oEntity.Vel.X,oEntity.Vel.Y - (float)DSMisc.GetRnd() * 15.0f ),
				"+" + nAmountOfEXP.ToString() + " Exp",System.Drawing.Color.Blue );

			//Well... did we level up?
			if( nPreExpLevelID != nPostExpLevelID && Globals.Inst().IAmTheServer == false )
			{
				AddRollingText( oEntity.Pos,
					new Vector2( oEntity.Vel.X*.90f,oEntity.Vel.Y*.90f - (float)DSMisc.GetRnd() * 15.0f ),
					"Level up!",System.Drawing.Color.Yellow );

                Globals.PlaySound(SoundConstants.m_cLEVELUP, oEntity.Location);
                oEntity.LevelUp();
                SLEntityEffect.StartLevelupEffect(oEntity);
			}

			if( oEntity.OwnerSocketID == Globals.Inst().GameEngine.DirectPlay.Me.SocketID )
			{
				Globals.Inst().Profile.IsDirty = true;
			}
		}

		#region Level management
		public static void GetLevelInfo( long nExpValue,ref long nLevelID,ref long nNextLevelEXP,ref ArrayList oSpecialTraits )
		{
			long nStartExp = 0;
			long nStopExp = 0;
			long nLevelIDTemp = 0;
			long nTraitEnumID = 0;
			string sBenefit = "";
			string[] saTemp = null;
			bool bDontAdd = false;
			object oTemp = null;
			ItemSpecialTrait oTrait = null;
			ItemSpecialTrait oLoopTrait = null;
			ArrayList oAbilities = new ArrayList();
			ArrayList oBenefits = new ArrayList();
			DSGobTable oLevelTable = null;
			DSGobTable oSTraitsTable = null;

			
			oSpecialTraits = new ArrayList();
			oLevelTable = DSResourceManager.GetGlobalInstance().GetGobTable( GobConstants.m_cTABLE_LEVELS );
			oSTraitsTable = DSResourceManager.GetGlobalInstance().GetGobTable( GobConstants.m_cTABLE_SPECIALTRAITS );
			nNextLevelEXP = -1;

			//Start by getting our level id
			for( int i=0 ; i<oLevelTable.RowCount ; i++ )
			{
				nLevelIDTemp = (Int32)oLevelTable.GetData( GobConstants.m_cCLMN_LEVELID,i );
				nStartExp = (Int32)oLevelTable.GetData( GobConstants.m_cCLMN_STARTINGEXP,i );
				nStopExp = (Int32)oLevelTable.GetData( GobConstants.m_cCLMN_STOPPINGEXP,i );
				oTemp = oLevelTable.GetData( GobConstants.m_cCLMN_BENEFIT,i );
				sBenefit = oTemp.ToString();

				if( nExpValue >= nStartExp && nExpValue <= nStopExp )
				{
					//Our level!
					nLevelID = nLevelIDTemp;
				}
				else if( nStartExp > nExpValue &&
						 ( nNextLevelEXP == -1 || nNextLevelEXP > nStartExp ) )
				{
					nNextLevelEXP = nStartExp;
				}
				if( nExpValue >= nStartExp && sBenefit.Length > 0 )
				{
					//We get the abilities
					oBenefits.Add( sBenefit );
				}
			}	

			//Now lets parse out the benefits string
			for( int i=0 ; i<oBenefits.Count ; i++ )
			{
				//SpecialTraitID:Value:SpecialTraidID:Value
				saTemp = DSMisc.Split( (string)oBenefits[i],":" );

				for( int nIdx=0 ; nIdx<saTemp.Length-1 ; nIdx+= 2 )
				{
					oTrait = new ItemSpecialTrait();
					oTrait.SpecialTraitID = Convert.ToInt32( saTemp[ nIdx ] );
					oTrait.Value = Convert.ToDouble( saTemp[ nIdx+1 ] );
					//Look up the enumeration value
					nTraitEnumID = (Int32)oSTraitsTable.FindValue( GobConstants.m_cCLMN_SPECIALTRAITID,oTrait.SpecialTraitID,GobConstants.m_cCLMN_ENUMERATIONID,true );
					oTrait.SpecialTraitEnum = (enumEntProperties)nTraitEnumID;

					//Now, no duplicates please
					bDontAdd = false;
					for( int nDupIdx=0 ; nDupIdx<oAbilities.Count ; nDupIdx++ )
					{
						if( nDupIdx >= oAbilities.Count ){ break; }

						oLoopTrait = (ItemSpecialTrait)oAbilities[ nDupIdx ];
						if( oLoopTrait.SpecialTraitEnum == oTrait.SpecialTraitEnum )
						{
							if( oLoopTrait.Value <= oTrait.Value )
							{
								oAbilities.RemoveAt( nDupIdx );
								nDupIdx--;
							}
							else 
							{
								bDontAdd = true;
							}
						}
					}

					//So, do we add it?
					if( bDontAdd == false )
					{
						oAbilities.Add( oTrait );
					}
				}
			}

			//Lastly, copy the benefits string.
			for( int i=0 ; i<oAbilities.Count ; i++ )
			{
				oLoopTrait = (ItemSpecialTrait)oAbilities[ i ];
				oSpecialTraits.Add( oLoopTrait );
			}
		}
		#endregion
		#region Rolling Text management
		public void AddRollingText( Vector2 vPos,Vector2 vVel,string sText,System.Drawing.Color oColor )
		{
			RollingText oNewText = null;


			oNewText = new RollingText();
			oNewText.Pos = vPos;
			oNewText.Vel = vVel;
			oNewText.Text = sText;
			oNewText.Color = oColor;
			oNewText.AppTimeTextStarted = Globals.Inst().GameEngine.AppTime;


			m_oRollingTexts.Add( oNewText );
		}
		#endregion
		#region Grid management
		private int CGetEntityGridX( Vector2 vMousePos )
		{
			int nNumTilesWide = 0, nNumTilesHigh = 0;
			int nGridTileSizeX = 0, nGridTileSizeY = 0;
			System.Drawing.Rectangle oShipRect = Rectangle.Empty;
			System.Drawing.Rectangle oRect = System.Drawing.Rectangle.Empty;

			oShipRect = GetShipGridDetails( ref nNumTilesWide,ref nNumTilesHigh,ref nGridTileSizeX,ref nGridTileSizeY );
			int nX = (int)( ( vMousePos.X -
							  ( oShipRect.Left + oShipRect.Width / 2.0
							    - nGridTileSizeX / 2.0 ) )
							/ nGridTileSizeX );
			if( vMousePos.X < oShipRect.Left + oShipRect.Width / 2.0 - nGridTileSizeX / 2.0 )
			{
				nX--;
			}

			return( nX );
		}
		private int CGetEntityGridY( Vector2 vMousePos )
		{
			int nNumTilesWide = 0, nNumTilesHigh = 0;
			int nGridTileSizeX = 0, nGridTileSizeY = 0;
			System.Drawing.Rectangle oShipRect = Rectangle.Empty;
			System.Drawing.Rectangle oRect = System.Drawing.Rectangle.Empty;

			oShipRect = GetShipGridDetails( ref nNumTilesWide,ref nNumTilesHigh,ref nGridTileSizeX,ref nGridTileSizeY );
			int nY = (int)( ( vMousePos.Y - 
								( oShipRect.Top + oShipRect.Height / 2.0f 
								  - nGridTileSizeY / 2.0 ) )
						/ -nGridTileSizeY );
			if( vMousePos.Y < oShipRect.Top + oShipRect.Height / 2.0f - nGridTileSizeY / 2.0 )
			{
				nY++;
			}

			return( nY );
		}
		private int CGetUnassignedGridX( Vector2 vMousePos )
		{
			int nNumTilesWide = 0, nNumTilesHigh = 0;
			int nGridTileSizeX = 0, nGridTileSizeY = 0;
			System.Drawing.Rectangle oInventoryRect = Rectangle.Empty;

			oInventoryRect = GetInvGridDetails( enumEditorObject.Chassis,ref nNumTilesWide,ref nNumTilesHigh,ref nGridTileSizeX,ref nGridTileSizeY );
			int nX = (int)( ( vMousePos.X - oInventoryRect.Left ) / nGridTileSizeX ) + m_nChassisPage * m_cEDITOR_GRID_WIDTH_CHASSIS;

			return( nX );
		}
		private int CGetUnassignedGridY( Vector2 vMousePos )
		{
			int nNumTilesWide = 0, nNumTilesHigh = 0;
			int nGridTileSizeX = 0, nGridTileSizeY = 0;
			System.Drawing.Rectangle oInventoryRect = Rectangle.Empty;

			oInventoryRect = GetInvGridDetails( enumEditorObject.Chassis,ref nNumTilesWide,ref nNumTilesHigh,ref nGridTileSizeX,ref nGridTileSizeY );
			int nY = -(int)( ( vMousePos.Y - oInventoryRect.Top ) / nGridTileSizeY );

			return( nY );
		}

		
		private int MGetEntityGridX( Chassis oChassis,Vector2 vMousePos )
		{
			int nNumTilesWide = 0, nNumTilesHigh = 0;
			int nGridTileSizeX = 0, nGridTileSizeY = 0;
			System.Drawing.Rectangle oShipRect = Rectangle.Empty;
			System.Drawing.Rectangle oRect = System.Drawing.Rectangle.Empty;
			int nX = 0;

			oShipRect = GetShipGridDetails( ref nNumTilesWide,ref nNumTilesHigh,ref nGridTileSizeX,ref nGridTileSizeY );
			if( oChassis == null )
			{
				nX = (int)( 
						( vMousePos.X -
							(
								oShipRect.Left + oShipRect.Width / 2.0 - nGridTileSizeX / 2.0 
							)
						)
						/ nGridTileSizeX );
				if( vMousePos.X < oShipRect.Left + oShipRect.Width / 2.0 - nGridTileSizeX / 2.0 )
				{
					nX--;
				}
			}
			else
			{
				nX = (int)( oShipRect.Left + oShipRect.Width / 2.0 - nGridTileSizeX / 2.0
						+ oChassis.XOffset * nGridTileSizeX );
				nX = (int)( ( vMousePos.X - nX ) / nGridTileSizeX );
			}

			return( nX );
		}
		private int MGetEntityGridY( Chassis oChassis,Vector2 vMousePos )
		{
			int nNumTilesWide = 0, nNumTilesHigh = 0;
			int nGridTileSizeX = 0, nGridTileSizeY = 0;
			System.Drawing.Rectangle oShipRect = Rectangle.Empty;
			System.Drawing.Rectangle oRect = System.Drawing.Rectangle.Empty;
			int nY = 0;

			oShipRect = GetShipGridDetails( ref nNumTilesWide,ref nNumTilesHigh,ref nGridTileSizeX,ref nGridTileSizeY );
			if( oChassis == null )
			{
				nY = (int)( 
						( vMousePos.Y -
							(
								oShipRect.Top + oShipRect.Height / 2.0f - nGridTileSizeY / 2.0 
							)
						)
					/ -nGridTileSizeY );
				if( vMousePos.Y < oShipRect.Top + oShipRect.Height / 2.0f - nGridTileSizeY / 2.0 )
				{
					nY++;
				}
			}
			else
			{
				nY = (int)( oShipRect.Top + oShipRect.Height / 2.0f - nGridTileSizeY / 2.0
					- oChassis.YOffset * nGridTileSizeY );
				nY = (int)( ( vMousePos.Y - nY ) / -nGridTileSizeY );
			}

			return( nY );
		}
		private int MGetUnassignedGridX( Vector2 vMousePos )
		{
			int nNumTilesWide = 0, nNumTilesHigh = 0;
			int nGridTileSizeX = 0, nGridTileSizeY = 0;
			System.Drawing.Rectangle oInventoryRect = Rectangle.Empty;

			oInventoryRect = GetInvGridDetails( enumEditorObject.Modules,ref nNumTilesWide,ref nNumTilesHigh,ref nGridTileSizeX,ref nGridTileSizeY );
			int nX = (int)( ( vMousePos.X - oInventoryRect.Left ) / nGridTileSizeX ) + m_nModulePage * m_cEDITOR_GRID_WIDTH_MODULE;

			return( nX );
		}
		private int MGetUnassignedGridY( Vector2 vMousePos )
		{
			int nNumTilesWide = 0, nNumTilesHigh = 0;
			int nGridTileSizeX = 0, nGridTileSizeY = 0;
			System.Drawing.Rectangle oInventoryRect = Rectangle.Empty;

			oInventoryRect = GetInvGridDetails( enumEditorObject.Modules,ref nNumTilesWide,ref nNumTilesHigh,ref nGridTileSizeX,ref nGridTileSizeY );
			int nY = -(int)( ( vMousePos.Y - oInventoryRect.Top ) / nGridTileSizeY );

			return( nY );
		}


		private int SGetEntityGridY( Vector2 vMousePos )
		{
			double nStartX = .02 * Globals.Inst().GameEngine.ScreenWidth;
			double nStartY = .05 * Globals.Inst().GameEngine.ScreenHeight;
			int nGridWidth = (int)( .225 * Globals.Inst().GameEngine.ScreenWidth );
			int nGridHeight = (int)( .09 * Globals.Inst().GameEngine.ScreenHeight );
			int nY = 0;


			nY = (int)( 
					( vMousePos.Y -
						(
							Globals.Inst().GameEngine.ScreenHeight / 2.0
							- nGridHeight / 2.0 
						)
					)
				/ -nGridHeight );
			if( vMousePos.Y < Globals.Inst().GameEngine.ScreenHeight / 2.0 
							- nGridHeight / 2.0 )
			{
				nY++;
			}

			return( nY );
		}
		private int SGetUnassignedGridY( Vector2 vMousePos )
		{
			int nInvBorder = 5;
			int nNumTilesWide = 0, nNumTilesHigh = 0;
			int nGridTileSizeX = 0, nGridTileSizeY = 0;
			System.Drawing.Rectangle oInventoryRect = Rectangle.Empty;

			oInventoryRect = GetInvGridDetails( enumEditorObject.Skins,ref nNumTilesWide,ref nNumTilesHigh,ref nGridTileSizeX,ref nGridTileSizeY );
			int nY = -(int)( ( vMousePos.Y - oInventoryRect.Top - nInvBorder ) / ( nGridTileSizeY + nInvBorder ) )
					- m_nSkinPage * nNumTilesHigh;

			return( nY );
		}


		private System.Drawing.Rectangle GetGridRectForChassis( int nCXOffset,int nCYOffset )
		{
			int nNumTilesWide = 0, nNumTilesHigh = 0;
			int nGridTileSizeX = 0, nGridTileSizeY = 0;
			System.Drawing.Rectangle oShipRect = Rectangle.Empty;
			System.Drawing.Rectangle oRect = System.Drawing.Rectangle.Empty;

			oShipRect = GetShipGridDetails( ref nNumTilesWide,ref nNumTilesHigh,ref nGridTileSizeX,ref nGridTileSizeY );
			oRect = new System.Drawing.Rectangle(
				(int)( oShipRect.Left + oShipRect.Width / 2.0f 
					   + nCXOffset * nGridTileSizeX 
				  	   - nGridTileSizeX / 2.0 ),
				(int)( oShipRect.Top + oShipRect.Height / 2.0f 
					   - nCYOffset * nGridTileSizeY
					   - nGridTileSizeY / 2.0 ),
				0,0 );

			return( oRect );
		}
		private System.Drawing.Rectangle GetGridRectForUnassignedChassis( int nCXOffset,int nCYOffset )
		{
			int nNumTilesWide = 0, nNumTilesHigh = 0;
			int nGridTileSizeX = 0, nGridTileSizeY = 0;
			System.Drawing.Rectangle oInventoryRect = Rectangle.Empty;
			System.Drawing.Rectangle oRect = System.Drawing.Rectangle.Empty;

			oInventoryRect = GetInvGridDetails( enumEditorObject.Chassis,ref nNumTilesWide,ref nNumTilesHigh,ref nGridTileSizeX,ref nGridTileSizeY );

			oRect = new System.Drawing.Rectangle(
				(int)( oInventoryRect.Left + ( nCXOffset - m_nChassisPage * m_cEDITOR_GRID_WIDTH_CHASSIS ) * nGridTileSizeX ),
				(int)( oInventoryRect.Top - nCYOffset * nGridTileSizeY ),
				0,0 );

			return( oRect );
		}
		private System.Drawing.Rectangle GetGridRectForModule( int nCXOffset,int nCYOffset,int nMXOffset,int nMYOffset )
		{
			int nNumTilesWide = 0, nNumTilesHigh = 0;
			int nGridTileSizeX = 0, nGridTileSizeY = 0;
			System.Drawing.Rectangle oShipRect = Rectangle.Empty;
			System.Drawing.Rectangle oRect = System.Drawing.Rectangle.Empty;

			oShipRect = GetShipGridDetails( ref nNumTilesWide,ref nNumTilesHigh,ref nGridTileSizeX,ref nGridTileSizeY );
			oRect = GetGridRectForChassis( nCXOffset,nCYOffset );
			oRect.X += (int)( nMXOffset * nGridTileSizeX );
			oRect.Y -= (int)( nMYOffset * nGridTileSizeY );

			return( oRect );
		}
		private System.Drawing.Rectangle GetGridRectForUnassignedModule( int nMXOffset,int nMYOffset )
		{
			int nNumTilesWide = 0, nNumTilesHigh = 0;
			int nGridTileSizeX = 0, nGridTileSizeY = 0;
			System.Drawing.Rectangle oInventoryRect = Rectangle.Empty;
			System.Drawing.Rectangle oRect = System.Drawing.Rectangle.Empty;

			oInventoryRect = GetInvGridDetails( enumEditorObject.Modules,ref nNumTilesWide,ref nNumTilesHigh,ref nGridTileSizeX,ref nGridTileSizeY );
			oRect = new System.Drawing.Rectangle(
				(int)( oInventoryRect.Left + ( nMXOffset - m_nModulePage * m_cEDITOR_GRID_WIDTH_MODULE ) * nGridTileSizeX ),
				(int)( oInventoryRect.Top - nMYOffset * nGridTileSizeY ),
				0,0 );
			
			return( oRect );
		}
		private System.Drawing.Rectangle GetGridRectForUnassignedSkin( int nYOffset )
		{
			int nInvBorder = 5;
			int nNumTilesWide = 0, nNumTilesHigh = 0;
			int nGridTileSizeX = 0, nGridTileSizeY = 0;
			System.Drawing.Rectangle oInventoryRect = Rectangle.Empty;
			System.Drawing.Rectangle oRect = System.Drawing.Rectangle.Empty;

			oInventoryRect = GetInvGridDetails( enumEditorObject.Skins,ref nNumTilesWide,ref nNumTilesHigh,ref nGridTileSizeX,ref nGridTileSizeY );
			oRect = new System.Drawing.Rectangle(
						(int)( oInventoryRect.Left + nInvBorder ),
						(int)( oInventoryRect.Top + nInvBorder + ( nYOffset - m_nSkinPage * nNumTilesHigh ) * ( nGridTileSizeY + nInvBorder ) ),
						nGridTileSizeX,nGridTileSizeY );
			
			return( oRect );
		}
		#endregion
		#region In Game Button management
		private System.Drawing.Rectangle GetMenuButtonRect()
		{
			LoadedTexture oTex = null;
			System.Drawing.Rectangle oRect = System.Drawing.Rectangle.Empty;


			oTex = DSResourceManager.GetGlobalInstance().GetLoadedTexture( GraphicConstants.m_cINGAME_MENU );
			oRect = new System.Drawing.Rectangle( 
				(int)( Globals.Inst().GameEngine.ScreenWidth / 2.0 - oTex.Size.X / 2.0 ),
				(int)( Globals.Inst().GameEngine.ScreenHeight - oTex.Size.Y ),
				(int)oTex.Size.X,(int)oTex.Size.Y );


			return( oRect );
		}
		private System.Drawing.Rectangle GetMenuSubButtonTextRect( int nIndex )
		{
			LoadedTexture oTex = null;
			System.Drawing.Rectangle oRect = System.Drawing.Rectangle.Empty;


			oTex = DSResourceManager.GetGlobalInstance().GetLoadedTexture( GraphicConstants.m_cINGAME_MENU );

			oRect = new System.Drawing.Rectangle( 
				(int)( Globals.Inst().GameEngine.ScreenWidth / 2.0 - oTex.Size.X / 2.0 + 20 ),
				(int)( Globals.Inst().GameEngine.ScreenHeight 
				- oTex.Size.Y - m_nMenuTop + nIndex * 30 + 3 ),
				100,30 );


			return( oRect );
		}
		private System.Drawing.Rectangle GetMenuSubButtonRect( int nIndex )
		{
			LoadedTexture oTex = null;
			System.Drawing.Rectangle oRect = System.Drawing.Rectangle.Empty;


			oTex = DSResourceManager.GetGlobalInstance().GetLoadedTexture( GraphicConstants.m_cINGAME_MENU );

			oRect = new System.Drawing.Rectangle( 
						(int)( Globals.Inst().GameEngine.ScreenWidth / 2.0 - oTex.Size.X / 2.0 ),
						(int)( Globals.Inst().GameEngine.ScreenHeight 
						- oTex.Size.Y - m_nMenuTop + nIndex * 30 ),
						30,30 );


			return( oRect );
		}
		#endregion
		#region Editor management
		public Module GetModuleAtCursor( Vector2 vCurPos,ref bool bUnassigned,ref Chassis oChassisAssignedTo,ref int nMX,ref int nMY )
		{
			System.Drawing.Rectangle oInventoryRect = System.Drawing.Rectangle.Empty;
			int nNumTilesWide = 0, nNumTilesHigh = 0;
			int nGridTileSizeX = 0, nGridTileSizeY = 0;
			int nCX = 0,nCY = 0;
			Module oLoopModule = null;
			Module oRetVal = null;


			//Sanity check!
			if( m_nCurrentScreen != enumGameScreen.Editor )
			{
				oRetVal = null;
			}
			else
			{
				//Find out what peice we clicked on
				oInventoryRect = GetInvGridDetails( enumEditorObject.Chassis,ref nNumTilesWide,ref nNumTilesHigh,ref nGridTileSizeX,ref nGridTileSizeY );
				nMX = MGetEntityGridX( null,vCurPos );
				nMY = MGetEntityGridY( null,vCurPos );
 
				//Peices assigned to a ship chassis
				if( oInventoryRect.Contains( (int)vCurPos.X,(int)vCurPos.Y ) == false )
				{
					nCX = CGetEntityGridX( vCurPos );
					nCY = CGetEntityGridY( vCurPos );

					oChassisAssignedTo = Globals.Inst().OurShip.GetChassisAtCGridLoc( nCX,nCY );
					if( oChassisAssignedTo != null )
					{
						nMX = MGetEntityGridX( oChassisAssignedTo,vCurPos );
						nMY = MGetEntityGridY( oChassisAssignedTo,vCurPos );

						oRetVal = oChassisAssignedTo.GetModuleAtMGridLoc( nMX,nMY );
						bUnassigned = false;
					}
				}
				//Unassigned pecies
				else if( m_nCurrentInEditorDisplay == enumEditorObject.Modules )
				{
					nMX = MGetUnassignedGridX( vCurPos );
					nMY = MGetUnassignedGridY( vCurPos );

					for( int i=0 ; i<Globals.Inst().Profile.UnassignedModules.Count ; i++ )
					{
						oLoopModule = (Module)Globals.Inst().Profile.UnassignedModules.GetByIndex( i );
						if( oLoopModule.MGridIsInUse( nMX-oLoopModule.XOffset,nMY-oLoopModule.YOffset ) == true )
						{
							oRetVal = oLoopModule;
							bUnassigned = true;
							break;
						}
					}
				}
			}


			return( oRetVal );
		}
		public Chassis GetChassisAtCursor( Vector2 vCurPos,ref bool bUnassigned,ref int nCX,ref int nCY )
		{
			System.Drawing.Rectangle oInventoryRect = System.Drawing.Rectangle.Empty;
			Chassis oLoopChassis = null;
			Chassis oRetVal = null;
			int nNumTilesWide = 0, nNumTilesHigh = 0;
			int nGridTileSizeX = 0, nGridTileSizeY = 0;


			//Sanity check!
			if( m_nCurrentScreen != enumGameScreen.Editor )
			{
				oRetVal = null;
			}
			else
			{
				//Find out what peice we clicked on
				oInventoryRect = GetInvGridDetails( enumEditorObject.Chassis,ref nNumTilesWide,ref nNumTilesHigh,ref nGridTileSizeX,ref nGridTileSizeY );

				//Assigned peices
				if( oInventoryRect.Contains( (int)vCurPos.X,(int)vCurPos.Y ) == false )
				{
					nCX = CGetEntityGridX( vCurPos );
					nCY = CGetEntityGridY( vCurPos );

					oRetVal = Globals.Inst().OurShip.GetChassisAtCGridLoc( nCX,nCY );
					bUnassigned = false;
				}
				//Unassigned peices
				else if( m_nCurrentInEditorDisplay == enumEditorObject.Chassis )
				{
					nCX = CGetUnassignedGridX( vCurPos );
					nCY = CGetUnassignedGridY( vCurPos );

					for( int i=0 ; i<Globals.Inst().Profile.UnassignedChassis.Count ; i++ )
					{
						oLoopChassis = (Chassis)Globals.Inst().Profile.UnassignedChassis.GetByIndex( i );
						if( oLoopChassis.CGridIsInUse( nCX - oLoopChassis.XOffset,nCY - oLoopChassis.YOffset ) == true )
						{
							oRetVal = oLoopChassis;
							bUnassigned = true;
							break;
						}
					}
				}
			}


			return( oRetVal );
		}
		public Skin GetSkinAtCursor( Vector2 vCurPos,ref bool bUnassigned,ref Chassis oChassis,ref int nSY )
		{
			int nCX = 0, nCY = 0;
			int nSkinRenderIndex = 0;
			//int nInvBorder = 5;
			int nNumTilesWide = 0, nNumTilesHigh = 0;
			int nGridTileSizeX = 0, nGridTileSizeY = 0;
			System.Drawing.Rectangle oInventoryRect = Rectangle.Empty;
			Skin oLoopSkin = null;
			Skin oRetVal = null;
			InventoryItems oInvItem = null;
			DSSortedList oItemList = new DSSortedList();


			//Sanity check!
			if( m_nCurrentScreen != enumGameScreen.Editor )
			{
				oRetVal = null;
			}
			else
			{
				//Get the basics
				oInventoryRect = GetInvGridDetails( enumEditorObject.Skins,ref nNumTilesWide,ref nNumTilesHigh,ref nGridTileSizeX,ref nGridTileSizeY );

				//Assigned
				if( oInventoryRect.Contains( (int)vCurPos.X,(int)vCurPos.Y ) == false )
				{
					nCX = CGetEntityGridX( vCurPos );
					nCY = CGetEntityGridY( vCurPos );
					oChassis = Globals.Inst().OurShip.GetChassisAtCGridLoc( nCX,nCY );
					if( oChassis != null && oChassis.DBSkinID != 0 )
					{
						oRetVal = new Skin( oChassis.ParentEntity );
						oRetVal.DBSkinID = oChassis.DBSkinID;
					}
					bUnassigned = false;
				}
				//Unassigned
				else if( m_nCurrentInEditorDisplay == enumEditorObject.Skins )
				{
					nSY = SGetUnassignedGridY( vCurPos );

					nSkinRenderIndex = 0;
					for( int i=0 ; i<Globals.Inst().Profile.UnassignedSkins.Count ; i++ )
					{
						oLoopSkin = (Skin)Globals.Inst().Profile.UnassignedSkins.GetByIndex( i );

						//Record it for stacking
						oInvItem = (InventoryItems)oItemList.GetByKey( oLoopSkin.DBSkinID.ToString() );
						if( oInvItem == null )
						{
							oInvItem = new InventoryItems();
							oInvItem.m_nYOffset = i;
							oItemList.Add( oLoopSkin.DBSkinID.ToString(),oInvItem );
						}
						oInvItem.m_nNumItems++;

						//Render it if its the first one on our list
						if( oInvItem.m_nNumItems == 1 && oLoopSkin.DBSkinID > 0 )
						{
							if( -nSY == nSkinRenderIndex )
							{
								oRetVal = oLoopSkin;
								bUnassigned = true;
								break;
							}
							nSkinRenderIndex++;
						}
					}
				}
			}


			return( oRetVal );
		}
		#endregion
		#region Direct Input Functions
		public bool DIMouseMoved( Vector2 vCurPos,MouseState oMouseStateData,bool[] baButtons )
		{
			bool bModuleUnassigned = false;
			bool bChassisUnassigned = false;
			bool bEndOldHover = false;
			Chassis oChassis = null;
			Module oModule = null;
			object oOldHover = null;
			int nMX = 0,nMY = 0;
			int nCX = 0,nCY = 0;


			//Have we moved off of our hover item?
			if( m_nCurrentScreen == enumGameScreen.Editor )
			{
				oOldHover = m_oCurrentMouseHoverPart;
				oModule = GetModuleAtCursor( vCurPos,ref bModuleUnassigned,ref oChassis,ref nMX,ref nMY );
				oChassis = GetChassisAtCursor( vCurPos,ref bChassisUnassigned,ref nCX,ref nCY );

				//Are we hovering over something new?
				if( oModule != null && m_nCurrentInEditorDisplay == enumEditorObject.Modules &&
					(
						m_oCurrentMouseHoverPart == null 
						||
						m_oCurrentMouseHoverPart.GetType().BaseType != typeof( Module ) 
						||
						(
							Globals.ObjectIsModule( m_oCurrentMouseHoverPart ) == true &&
							((Module)m_oCurrentMouseHoverPart).PKey != oModule.PKey
						)
					)
				  )
				{
					m_vMouseHoverPoint = vCurPos;
					m_bHaveStartedHovering = false;
					m_nAppTimeOfLastMouseMove = Globals.Inst().GameEngine.AppTime;
					m_oCurrentMouseHoverPart = oModule;
					bEndOldHover = true;
				}
				else if( oChassis != null && m_nCurrentInEditorDisplay == enumEditorObject.Chassis &&
						(
							m_oCurrentMouseHoverPart == null 
							||
							Globals.ObjectIsChassis( m_oCurrentMouseHoverPart ) == true 
							||
							(
								m_oCurrentMouseHoverPart.GetType().BaseType == typeof( Chassis ) &&
								((Chassis)m_oCurrentMouseHoverPart).PKey != oChassis.PKey
							)
						)
					  )
				{
					m_vMouseHoverPoint = vCurPos;
					m_bHaveStartedHovering = false;
					m_nAppTimeOfLastMouseMove = Globals.Inst().GameEngine.AppTime;
					m_oCurrentMouseHoverPart = oChassis;
					bEndOldHover = true;
				}
				else if( oModule == null && oChassis == null && m_oCurrentMouseHoverPart != null )
				{
					m_bHaveStartedHovering = false;
					m_nAppTimeOfLastMouseMove = Globals.Inst().GameEngine.AppTime;
					m_oCurrentMouseHoverPart = null;
					bEndOldHover = true;
				}

				//End the old hover
				if( bEndOldHover == true && oOldHover != null )
				{
					if( Globals.ObjectIsModule( oOldHover ) == true )
					{
						((Module)oOldHover).HoverStop();
					}
					else if( Globals.ObjectIsChassis( oOldHover ) == true )
					{
						((Chassis)oOldHover).HoverStop();
					}						
				}
			}
			else
			{
				m_nAppTimeOfLastMouseMove = Globals.Inst().GameEngine.AppTime;
			}


			return( false );
		}

		public bool DIMouseDown( Vector2 vCurPos,long nButton )
		{
			int nCX = 0,nCY = 0;
			int nMX = 0,nMY = 0;
			int nSX = 0,nSY = 0;
			int nTabClicked = -1;
			int nTempPage = 0;
			bool bUnassigned = false;
			bool bButtonClicked = false;
			string sGraphicsKey = "";
			string sText = "";
			DSSortedList oMyChassesDependents = null;
			//DSSortedList oOthersChassesDependents = null;
			Chassis oLoopChassis = null;
			Module oLoopModule = null;
			Skin oLoopSkin = null;
			RedChassis oRedChassis = null;
			System.Drawing.Rectangle oBulletRect = System.Drawing.Rectangle.Empty;
			System.Drawing.Rectangle oTextRect = System.Drawing.Rectangle.Empty;
			System.Drawing.Rectangle oTargetRect = System.Drawing.Rectangle.Empty;


			//Get rid of any popups we may have going
			CloseHoverWindow();

			#region Menu Buttons
			//Did they click on the menu?
			if( m_bMenuIsOpen == true )
			{
				for( int i=0 ; i<3 ; i++ )
				{
					oBulletRect = GetMenuSubButtonRect( i );
					oTextRect = GetMenuSubButtonTextRect( i );
					if( oBulletRect.Contains(	(int)( Globals.Inst().GameEngine.MouseCursor.X ),
						(int)( Globals.Inst().GameEngine.MouseCursor.Y ) )== true ||
						oTextRect.Contains(	(int)( Globals.Inst().GameEngine.MouseCursor.X ),
						(int)( Globals.Inst().GameEngine.MouseCursor.Y ) )== true )
					{
						if( i == 0 )
						{
							//Clicked resume 
							LaunchResumeMenu( this,new System.EventArgs() );
							bButtonClicked = true;
						}
						else if( i == 1 )
						{
							LaunchEditor( true );
							bButtonClicked = true;
						}
						else if( i == 2 )
						{
							LaunchCharSheet( true );
							bButtonClicked = true;
						}
					}
				}
			}
			#endregion

			#region Menu Button
			oTargetRect = GetMenuButtonRect();
			if( oTargetRect.Contains( 
				(int)( Globals.Inst().GameEngine.MouseCursor.X ),
				(int)( Globals.Inst().GameEngine.MouseCursor.Y ) )== true )
			{
				bButtonClicked = true;
				LaunchEditor( false );
				LaunchCharSheet( false );
			}
			if( bButtonClicked == true )
			{
				m_bMenuIsOpen = !m_bMenuIsOpen;
                Globals.PlaySound(SoundConstants.m_cMENUCLICK,null);
			}
			#endregion

			#region Editor Tabs
			if( m_nCurrentScreen == enumGameScreen.Editor )
			{
				m_nAppTimeOfLastMouseMove = Globals.Inst().GameEngine.AppTime;

				#region Did we click on an arrow?
				for( int i=0 ; i<4 ; i++ )
				{
					oTargetRect = GetArrowRect( i,ref sGraphicsKey );
					if( oTargetRect.Contains( (int)vCurPos.X,(int)vCurPos.Y ) == true )
					{
							 if( m_nCurrentInEditorDisplay == enumEditorObject.Chassis ){ nTempPage = m_nChassisPage; }
						else if( m_nCurrentInEditorDisplay == enumEditorObject.Modules ){ nTempPage = m_nModulePage; }
						else if( m_nCurrentInEditorDisplay == enumEditorObject.Skins )	{ nTempPage = m_nSkinPage; }

						//Adjust our arrow stuff
						if( i == 0 && nTempPage > 0 )
						{
							nTempPage = DSMisc.Max( nTempPage - 10,0 );
						}
						else if( i == 1 && nTempPage > 0 )
						{
							nTempPage = DSMisc.Max( nTempPage - 1,0 );
						}
						else if( i == 2 )
						{
							nTempPage++;
						}
						else if( i == 3 )
						{
							nTempPage += 10;
						}
                        Globals.PlaySound(SoundConstants.m_cMENUCLICK,null);

							 if( m_nCurrentInEditorDisplay == enumEditorObject.Chassis ){ m_nChassisPage = nTempPage; }
						else if( m_nCurrentInEditorDisplay == enumEditorObject.Modules ){ m_nModulePage = nTempPage; }
						else if( m_nCurrentInEditorDisplay == enumEditorObject.Skins )	{ m_nSkinPage = nTempPage; }

						break;
					}
				}
				#endregion

				//Did we click on a tab?
				for( int i=0 ; i<m_cNUMBEROFTABS ; i++ )
				{
					oTargetRect = GetTabRect( i,ref sText );
					if( oTargetRect.Contains( (int)vCurPos.X,(int)vCurPos.Y ) == true )
					{
						nTabClicked = i;
					}						
				}


				if( nTabClicked != -1 )
				{
					m_nCurrentInEditorDisplay = (enumEditorObject)nTabClicked;
                    Globals.PlaySound(SoundConstants.m_cMENUCLICK,null);
				}
				else if( m_nCurrentInEditorDisplay == enumEditorObject.Chassis )
				{
					oLoopChassis = GetChassisAtCursor( vCurPos,ref bUnassigned,ref nCX,ref nCY );

					if( oLoopChassis != null && bUnassigned == false )
					{
						//One last check to see if we can remove this chassis
						oMyChassesDependents = Globals.Inst().OurShip.GetDependentChildrenOfChassis( oLoopChassis );
						if( oMyChassesDependents.Count > 0 )
						{
							//Mark all the chasses that are dependent children red
							#region My dependence children red
							for( int nCldIdx=0 ; nCldIdx<oMyChassesDependents.Count ; nCldIdx++ )
							{
								oLoopChassis = (Chassis)oMyChassesDependents.GetByIndex( nCldIdx );
								if( m_oRedChasses.ContainsKey( oLoopChassis.PKey ) == true )
								{
									oRedChassis = (RedChassis)m_oRedChasses.GetByKey( oLoopChassis.PKey );
								}
								else
								{
									oRedChassis = new RedChassis();
									oRedChassis.m_oChassis = oLoopChassis;
									m_oRedChasses.Add( oLoopChassis.PKey,oRedChassis );
								}
								oRedChassis.m_nTimeRed = m_cCHASSIS_REDFLASH_TIME;
								oRedChassis.m_nTimeRedStarted = Globals.Inst().GameEngine.AppTime;
							}
							#endregion
						}
						else
						{
							Globals.Inst().OurShip.RemoveChassis( oLoopChassis );
							m_oDraggingChassis = oLoopChassis;
							m_oDraggingChassis.UnAssign();
							m_nDraggingStartX = nCX;
							m_nDraggingStartY = nCY;
						}
					}
					else if( oLoopChassis != null && bUnassigned == true )
					{
						m_oDraggingChassis = oLoopChassis;
						m_nDraggingStartX = -11;
						m_nDraggingStartY = nCY;

						Globals.Inst().Profile.UnassignedChassis.Remove( m_oDraggingChassis.PKey );
					}
				}
				//Modules!
				else if( m_nCurrentInEditorDisplay == enumEditorObject.Modules )
				{
					oLoopModule = GetModuleAtCursor( vCurPos,ref bUnassigned,ref oLoopChassis,ref nMX,ref nMY );

					if( oLoopModule != null )
					{
						if( bUnassigned == false )
						{
							oLoopChassis.DelModule( oLoopModule );
						}
						else if( bUnassigned == true )
						{
							Globals.Inst().Profile.UnassignedModules.Remove( oLoopModule.PKey );
						}

						m_oDraggingModule = oLoopModule;
						m_oDraggingModule.UnAssign();
						m_nDraggingStartX = nMX;
						m_nDraggingStartY = nMY;

						if( m_oDraggingModulePlacableLocsCalculation != null )
						{
							m_oDraggingModulePlacableLocsCalculation.Abort();
							m_oDraggingModulePlacableLocsCalculation = null;
						}
						m_oaDraggingModulePlacableLocs = null;
						m_oDraggingModulePlacableLocsCalculation = new System.Threading.Thread( 
																		new System.Threading.ThreadStart( 
																			this.CalculateModulePlacableLocsThreadingly ) );
						m_oDraggingModulePlacableLocsCalculation.IsBackground = true;
						m_oDraggingModulePlacableLocsCalculation.Priority = System.Threading.ThreadPriority.BelowNormal;
						m_oDraggingModulePlacableLocsCalculation.Start();
					}
				}
				//Skins!
				else if( m_nCurrentInEditorDisplay == enumEditorObject.Skins )
				{
					oLoopSkin = GetSkinAtCursor( vCurPos,ref bUnassigned,ref oLoopChassis,ref nSY );
					if( oLoopSkin != null && oLoopSkin.DBSkinID > 0 )
					{
						if( bUnassigned == false )
						{
							oLoopChassis.DBSkinID = 0;
						}
						else if( bUnassigned == true )
						{
							Globals.Inst().Profile.UnassignedSkins.Remove( oLoopSkin.PKey );
						}

						m_oDraggingSkin = oLoopSkin;
						m_nDraggingStartX = nSX;
						m_nDraggingStartY = nSY;
					}
				}
			}
			#endregion


			return( false );
		}
		public bool DIMouseUp( Vector2 vCurPos,long nButton )
		{
			string sGraphicKey = "";
			System.Drawing.Rectangle oTargetRect = System.Drawing.Rectangle.Empty;
			System.Drawing.Rectangle oInventoryRect = System.Drawing.Rectangle.Empty;
			ArrayList oaConflicts = null;
			int nCX = 0,nCY = 0;
			int nMX = 0,nMY = 0;
			int nNumTilesWide = 0, nNumTilesHigh = 0;
			int nGridTileSizeX = 0, nGridTileSizeY = 0;
			Skin oNewSkin = null;
			//RedChassis oRedChassis = null;
			Module oLoopModule = null;
			Chassis oLoopChassis = null;
			Chassis oChassis = null;
			bool bUnassigned = false;
			bool bFound = false;


			if( m_oDraggingChassis != null )
			{
				//Make sure there are no overlaps
				oInventoryRect = GetInvGridDetails( enumEditorObject.Chassis,ref nNumTilesWide,ref nNumTilesHigh,ref nGridTileSizeX,ref nGridTileSizeY );
				//Find out what peice we clicked on
				nCX = CGetEntityGridX( vCurPos );
				nCY = CGetEntityGridY( vCurPos );
				//Assigned chassis
				if( oInventoryRect.Contains( (int)vCurPos.X,(int)vCurPos.Y ) == false )
				{
					if( m_oDraggingChassis.MinLevel > Globals.Inst().OurShip.LevelID )
					{
						//Nope, we can't use this yet...
						Globals.Inst().Profile.AddChassis( m_oDraggingChassis );

						//Send an alert
						m_oAlertManager.AddMessage( "Item requires level " + m_oDraggingChassis.MinLevel.ToString() + 
							" but you are only level " + Globals.Inst().OurShip.LevelID.ToString() );

						m_oDraggingChassis = null;
					}
					else if( Globals.Inst().OurShip.CanChassisBePlaced( m_oDraggingChassis,nCX,nCY,ref oaConflicts ) == true )
					{
						if( Globals.Inst().OurShip.Chasses.Count == 0 )
						{
							m_oDraggingChassis.XOffset = (int)-( m_oDraggingChassis.CGridWidth / 2.0 );
							m_oDraggingChassis.YOffset = (int)( m_oDraggingChassis.CGridHeight / 2.0 );
						}
						else
						{
							m_oDraggingChassis.XOffset = nCX;
							m_oDraggingChassis.YOffset = nCY;
						}

						m_oDraggingChassis.Assign();
						Globals.Inst().OurShip.AddChassis( m_oDraggingChassis );
					}
					else
					{
						//Drop this back in our unassigned list
						Globals.Inst().Profile.AddChassis( m_oDraggingChassis );
                        m_oDraggingChassis.XOffset = m_nChassisPage* m_cEDITOR_GRID_WIDTH_CHASSIS;
                        m_oDraggingChassis.YOffset = 0;
					}
				}
				//Unassigned chassis
				else
				{
					//Find out what peice we clicked on
					if( oInventoryRect.Contains( (int)vCurPos.X,(int)vCurPos.Y ) == true )
					{
						nCX = CGetUnassignedGridX( vCurPos );
						nCY = CGetUnassignedGridY( vCurPos );
					}
					else
					{
						nCX = 0;
						nCY = 0;
					}
					Globals.Inst().Profile.AddChassis( m_oDraggingChassis );
					m_oDraggingChassis.XOffset = nCX;
					m_oDraggingChassis.YOffset = nCY;

					//Now go through and move all peices of the same type with no abilities to the same place
					/*if( m_oDraggingChassis.SpecialTraits.Count == 0 )
					{
						for( int i=Globals.Inst().Profile.UnassignedChassis.Count-1 ; i>=0 ; i-- )
						{
							oLoopChassis = (Chassis)Globals.Inst().Profile.UnassignedChassis.GetByIndex( i );

							//Is this chassis on this page?
							if( oLoopChassis.XOffset >= m_nChassisPage * m_cEDITOR_GRID_WIDTH_CHASSIS &&
								oLoopChassis.XOffset < ( m_nChassisPage + 1 ) * m_cEDITOR_GRID_WIDTH_CHASSIS &&
								oLoopChassis.Active == true && oLoopChassis.SpecialTraits.Count == 0 &&
								oLoopChassis.Name == m_oDraggingChassis.Name )
							{
								oLoopChassis.XOffset = nCX;
								oLoopChassis.YOffset = nCY;
							}
						}
					}*/
				}
				m_oDraggingChassis = null;
			}
			else if( m_oDraggingModule != null )
			{
				oInventoryRect = GetInvGridDetails( enumEditorObject.Modules,ref nNumTilesWide,ref nNumTilesHigh,ref nGridTileSizeX,ref nGridTileSizeY );
				bFound = false;

				//Assigned modules
				if( oInventoryRect.Contains( (int)vCurPos.X,(int)vCurPos.Y ) == false )
				{
					if( m_oDraggingModule.MinLevel > Globals.Inst().OurShip.LevelID )
					{
						//Nope, we can't use this yet...
						Globals.Inst().Profile.AddModule( m_oDraggingModule );
	
						//Send an alert
						m_oAlertManager.AddMessage( "Item requires level " + m_oDraggingModule.MinLevel.ToString() + 
							" but you are only level " + Globals.Inst().OurShip.LevelID.ToString() );
	
						m_oDraggingModule = null;
					}
					else 
					{
						nMX = MGetEntityGridX( null,vCurPos );
						nMY = MGetEntityGridY( null,vCurPos );

						if( Globals.Inst().OurShip.CanModuleBePlaced( m_oDraggingModule,nMX,nMY,ref oaConflicts,ref oChassis ) == true )
						{
							m_oDraggingModule.Assign();
							oChassis.AddModule( m_oDraggingModule );

							m_oDraggingModule.XOffset = nMX - oChassis.XOffset;
							m_oDraggingModule.YOffset = nMY - oChassis.YOffset;
							bFound = true;
						}
					}
				}
				//Unassigned modules
				else if( oInventoryRect.Contains( (int)vCurPos.X,(int)vCurPos.Y ) == true )
				{
					oTargetRect = GetArrowRect( 0,ref sGraphicKey );

					nCX = MGetUnassignedGridX( vCurPos );
					nCY = MGetUnassignedGridY( vCurPos );
					if( vCurPos.Y > oTargetRect.Top - 10 )
					{
						nCY += m_oDraggingModule.MGridHeight;
					}

					m_oDraggingModule.XOffset = nCX;
					m_oDraggingModule.YOffset = nCY;

					//Now go through and move all peices of the same type with no abilities to the same place
					/*if( m_oDraggingModule.SpecialTraits.Count == 0 )
					{
						for( int i=Globals.Inst().Profile.UnassignedModules.Count-1 ; i>=0 ; i-- )
						{
							oLoopModule = (Module)Globals.Inst().Profile.UnassignedModules.GetByIndex( i );

							//Is this Module on this page?
							if( oLoopModule.XOffset >= m_nModulePage * m_cEDITOR_GRID_WIDTH_MODULE &&
								oLoopModule.XOffset < ( m_nModulePage + 1 ) * m_cEDITOR_GRID_WIDTH_MODULE &&
								oLoopModule.Active == true && oLoopModule.SpecialTraits.Count == 0 &&
								oLoopModule.Name == m_oDraggingModule.Name )
							{
								oLoopModule.XOffset = nCX;
								oLoopModule.YOffset = nCY;
							}
						}
					}*/
				}

				if( bFound == false )
				{
					Globals.Inst().Profile.AddModule( m_oDraggingModule );
				}
				m_oDraggingModule = null;
			}
			else if( m_oDraggingSkin != null )
			{
				oInventoryRect = GetInvGridDetails( enumEditorObject.Skins,ref nNumTilesWide,ref nNumTilesHigh,ref nGridTileSizeX,ref nGridTileSizeY );
				bFound = false;

				//Assigned modules
				if( oInventoryRect.Contains( (int)vCurPos.X,(int)vCurPos.Y ) == false )
				{
					//Find the chassis this works for
					oLoopChassis = GetChassisAtCursor( vCurPos,ref bUnassigned,ref nCX,ref nCY );
					if( oLoopChassis != null )
					{
						if( oLoopChassis.DBSkinID != 0 )
						{
							oNewSkin = new Skin();
							oNewSkin.DBSkinID = oLoopChassis.DBSkinID;
							Globals.Inst().Profile.UnassignedSkins.Add( oNewSkin.PKey,oNewSkin );
						}

						oLoopChassis.DBSkinID = m_oDraggingSkin.DBSkinID;
						bFound = true;
					}
				}

				if( bFound == false )
				{
					Globals.Inst().Profile.UnassignedSkins.Add( m_oDraggingSkin.PKey,m_oDraggingSkin );
				}
				m_oDraggingSkin = null;
			}


			return( false );
		}
		public bool DIKeyboardKeyDown( Key oKey,bool[] oState )
		{
			int nDelta = 0;


			if( oKey == Key.Return || oKey == Key.NumPadEnter )
			{
				if( m_bTyping == true )
				{
					if( AddChatMsg( Globals.Inst().GameEngine.DirectPlay.Me,m_sTypingText ) == true )
					{
						NetMsg.Send_GameChat( Globals.Inst().GameEngine.DirectPlay,
							Globals.Inst().GameEngine.DirectPlay.Me,
							Globals.Inst().GameEngine.DirectPlay.PlayerWhoIsHost,m_sTypingText );
					}
				}
				else 
				{
                    Globals.PlaySound(SoundConstants.m_cTYPING,null);
				}
				m_bTyping = !m_bTyping;
				m_sTypingText = "";
			}
			else if( m_bTyping == true )
			{
				if( oKey == Key.BackSpace )
				{
					if( m_sTypingText.Length > 0 )
					{
						m_sTypingText = m_sTypingText.Substring( 0,m_sTypingText.Length - 1 );
					}
				}
				else
				{
					m_sTypingText += DSMisc.KeyToChar( oKey,oState );
				}
                Globals.PlaySound(SoundConstants.m_cTYPING,null);
			}
			else if( oKey == Key.E )
			{
				LaunchEditor( true );
			}
			else if( oKey == Key.I )
			{
				LaunchCharSheet( true );
			}
			else if( oKey == Key.U )
			{
				if( m_nCurrentInEditorDisplay == enumEditorObject.Chassis )
				{
					m_nCurrentInEditorDisplay = enumEditorObject.Modules;
				}
				else if( m_nCurrentInEditorDisplay == enumEditorObject.Modules )
				{
					m_nCurrentInEditorDisplay = enumEditorObject.Skins;
				}
				else if( m_nCurrentInEditorDisplay == enumEditorObject.Skins )
				{
					m_nCurrentInEditorDisplay = enumEditorObject.Chassis;
				}
			}
			else if( oKey == Key.S )
			{
				AdjustZoomLevel( m_cDEFAULT_ZOOM );
			}
			else if( m_nCurrentScreen == enumGameScreen.Editor )
			{
				int nOrigValue = 0;

				if( m_nCurrentInEditorDisplay == enumEditorObject.Chassis )
				{
					nOrigValue = m_nChassisPage;
				}
				else if( m_nCurrentInEditorDisplay == enumEditorObject.Modules )
				{
					nOrigValue = m_nModulePage;
				}
				else if( m_nCurrentInEditorDisplay == enumEditorObject.Skins )
				{
					nOrigValue = m_nSkinPage;
				}

				//Get our delta change
				if( oKey == Key.LeftArrow || oKey == Key.Left )
				{
					nDelta = -1;
				}
				else if( oKey == Key.RightArrow || oKey == Key.Right )
				{
					nDelta = 1;
				}

				if( oState[ (int)Key.LeftShift ] == true || oState[ (int)Key.RightShift ] == true )
				{
					nDelta *= 10;
				}
				if( oState[ (int)Key.LeftAlt ] == true || oState[ (int)Key.RightAlt ] == true )
				{
					nDelta *= 100;
				}

				//Now, move us
				nOrigValue = DSMisc.Max( 0, nOrigValue+nDelta );

				//Now write the values back
				if( m_nCurrentInEditorDisplay == enumEditorObject.Chassis )
				{
					m_nChassisPage = nOrigValue;
				}
				else if( m_nCurrentInEditorDisplay == enumEditorObject.Modules )
				{
					m_nModulePage = nOrigValue;
				}
				else if( m_nCurrentInEditorDisplay == enumEditorObject.Skins )
				{
					m_nSkinPage = nOrigValue;
				}
			}
			else 
			{
				if( m_nCurrentScreen == enumGameScreen.InSpace || m_nCurrentScreen == enumGameScreen.CharSheet )
				{
					//Process our key imputs for our ship
					DSNetworkWrapper oNet = Globals.Inst().Network;
                    Globals.Inst().OurShip.KeyProcess(this, oKey, true);
					NetMsg.Send_EntityKeyPress( oNet,oNet.PlayerWhoIsHost,Globals.Inst().OurShip,oKey,true );
				}
				else
				{
					if( m_oDraggingChassis != null )
					{
						if( oKey == Key.LeftArrow )
						{
							m_oDraggingChassis.Direction = enumChassisDirection.Left;
						}
						else if( oKey == Key.RightArrow )
						{
							m_oDraggingChassis.Direction = enumChassisDirection.Right;
						}
						else if( oKey == Key.UpArrow )
						{
							m_oDraggingChassis.Direction = enumChassisDirection.Up;
						}
						else if( oKey == Key.DownArrow )
						{
							m_oDraggingChassis.Direction = enumChassisDirection.Down;
						}
					}
				}
			}


			return( false );
		}
		public bool DIKeyboardKeyUp( Key oKey,bool[] oState )
		{
			if( m_nCurrentScreen == enumGameScreen.InSpace || m_nCurrentScreen == enumGameScreen.CharSheet )
			{
				//Process our key imputs for our ship
				DSNetworkWrapper oNet = Globals.Inst().Network;
                Globals.Inst().OurShip.KeyProcess(this, oKey, false);
				NetMsg.Send_EntityKeyPress( oNet,oNet.PlayerWhoIsHost,Globals.Inst().OurShip,oKey,false );

			}

			return( false );
		}


		private void CalculateModulePlacableLocsThreadingly()
		{
			if( m_oDraggingModule != null )
			{
				m_oaDraggingModulePlacableLocs = Globals.Inst().OurShip.GetMGridPlacableLocs( m_oDraggingModule );
			}
		}
		private void UpdateOurZoomLevel( double nElapsedTime )
		{
			double nChange = 0;
			bool[] oKeyboardState = null;


			if( Globals.Inst().IAmTheServer == false &&
				m_bTyping == false &&
				Globals.Inst().GameEngine.DirectInput.GetKeyboardState( ref oKeyboardState ) == true )
			{
				nChange = m_nCurrentZoom * nElapsedTime;

				if( oKeyboardState[ (int)Key.Z ] == true )
				{
					AdjustZoomLevel( m_nCurrentZoom + nChange );
					//m_nCurrentZoom += nChange;
				}
				else if( oKeyboardState[ (int)Key.A ] == true )
				{
					AdjustZoomLevel( m_nCurrentZoom - nChange );
					//m_nCurrentZoom -= nChange;
				}

				//Set our bounds
				m_nCurrentZoom = DSMisc.Max( m_nCurrentZoom,.1 );
				m_nCurrentZoom = DSMisc.Min( m_nCurrentZoom,4 );
			}
		}
		private void LaunchEditor( bool bOpen )
		{
			if( m_nCurrentScreen == enumGameScreen.InSpace && bOpen == true )
			{
				m_nCurrentScreen = enumGameScreen.Editor;
			}
			else
			{
				m_nCurrentScreen = enumGameScreen.InSpace;
				Globals.Inst().Profile.SaveToFile( false );

				//Get rid of any popups we may have going
				CloseHoverWindow();

				//Send them an update
                TransmitEntity(Globals.Inst().OurShip, true);
			}

			//Update our in play status
			Globals.Inst().OurShip.IsInPlay = ( m_nCurrentScreen == enumGameScreen.InSpace );
			NetMsg.Send_SetEntityInPlayStatus( Globals.Inst().GameEngine.DirectPlay,Globals.Inst().OurShip );
		}
		private void CloseHoverWindow()
		{
			//Get rid of any popups we may have going
			if( m_oCurrentMouseHoverPart != null )
			{
				if( Globals.ObjectIsModule( m_oCurrentMouseHoverPart ) == true )
				{
					((Module)m_oCurrentMouseHoverPart).HoverStop();
				}
				else if( Globals.ObjectIsChassis( m_oCurrentMouseHoverPart ) == true )
				{
					((Chassis)m_oCurrentMouseHoverPart).HoverStop();
				}			
			}
		}
		private void LaunchCharSheet( bool bOpen )
		{
			if( m_nCurrentScreen == enumGameScreen.InSpace && bOpen == true )
			{
				m_nCurrentScreen = enumGameScreen.CharSheet;
			}
			else
			{
				m_nCurrentScreen = enumGameScreen.InSpace;
			}
		}
		private void AdjustZoomLevel( double nNewZoom )
		{
			double nTempNewZoom = 1;
			double nPercChange = 0;


			//Find the percentage change that is
			nTempNewZoom = DSMisc.Max( nNewZoom,.1 );
			nTempNewZoom = DSMisc.Min( nTempNewZoom,4 );
			nPercChange = m_nCurrentZoom / nTempNewZoom;

			m_oStarscape.AdjustZoomLevel( nPercChange );
			m_nCurrentZoom = nTempNewZoom;
		}
		#endregion


		#region Properties
		public string SessionName
		{
			get
			{
				return( m_sSessionName );
			}
			set
			{
				m_sSessionName = value;
			}
		}
		public string GUID
		{
			get
			{
				return( m_sGUID );
			}
			set
			{
				m_sGUID = value;
			}
		}
		/*public ArrayList EntitiesNeedingToBeSent_Full
		{
			get
			{
				return( m_oEntitiesNeedingToBeSent_Full );
			}
			set
			{
				lock( m_oEntitiesNeedingToBeSent_Full )
				{
					m_oEntitiesNeedingToBeSent_Full = value;
				}
			}
		}
		public ArrayList EntitiesNeedingToBeSent_Lite
		{
			get
			{
				return( m_oEntitiesNeedingToBeSent_Lite );
			}
			set
			{
				lock( m_oEntitiesNeedingToBeSent_Lite )
				{
					m_oEntitiesNeedingToBeSent_Lite = value;
				}
			}
		}*/
		public DSSortedList UnassignedChassis
		{
			get
			{
				DSSortedList o = null;
				try
				{
					o = Globals.Inst().Profile.UnassignedChassis;
				}
				catch( System.Exception oEx )
				{
					DSMisc.ShowErrors( oEx );
				}
				return( o );
			}
			set
			{
				Globals.Inst().Profile.UnassignedChassis = value;
			}
		}
		public DSSortedList UnassignedModules
		{
			get
			{
				return( Globals.Inst().Profile.UnassignedModules );
			}
			set
			{
				Globals.Inst().Profile.UnassignedModules = value;
			}
		}
		public System.Drawing.Rectangle AreaToDrawAt
		{
			get
			{
				return( m_oAreaToDrawAt );
			}
		}
		public Entity EntityCenteredOn
		{
			get
			{
				return( m_oEntityCenteredOn );
			}
		}
		public Vector2 EntityOffset
		{
			get
			{
				return( m_vEntityOffset );
			}
		}
		public double ZoomLevel
		{
			get
			{
				return( m_nZoomLevel );
			}
			set
			{
				m_nZoomLevel = value;
			}
		}
		public RenderSettings LastRenderSettingsUsed
		{
			get
			{
				return( m_oLastRenderSettingsUsed );
			}
		}

        public Zones Zones
        {
            get
            {
                return (m_oZones);
            }
        }

		public double Width
		{
			get
			{
				return( 6000 );
			}
		}
		public double Height
		{
			get
			{
				return( 6000 );
			}
		}

		public double CurrentZoom
		{
			get
			{
				return( m_nCurrentZoom );
			}
		}

		public bool Debug_NoAI
		{
			set
			{
				m_bDebug_NoAI = value;
			}
			get
			{
				return( m_bDebug_NoAI );
			}
		}
		public bool Debug_Pause
		{
			set
			{
				m_bDebug_Pause = value;
			}
			get
			{
				return( m_bDebug_Pause );
			}
		}		
		/*public WaveManager WaveManager
		{
			get
			{
				return( m_oWaveManager );
			}
			set
			{
				m_oWaveManager = value;
			}
		}*/
        public Starscape Starscape
        {
            get
            {
                return (m_oStarscape);
            }
            set
            {
                m_oStarscape = value;
            }
        }

        public bool HaveReceivedSession
        {
            get
            {
                return (m_bHaveReceivedSession);
            }
            set
            {
                m_bHaveReceivedSession = value;
            }
        }
        public System.Collections.Generic.List<Zone> ReceivingZones
        {
            get
            {
                return (m_oaZones);
            }
            set
            {
                m_oaZones = value;
            }
        }
		#endregion
    }


    #region Helper Classes
    public class InventoryItems
	{
		public int m_nNumItems;
		public int m_nXOffset;
		public int m_nYOffset;
		public int m_nWidth;
		public int m_nHeight;
	}
	public class RenderSettings
	{
		#region Properties
		private System.Drawing.Rectangle m_oAreaToDrawAt = System.Drawing.Rectangle.Empty;
		private Entity m_oEntityToCenterOn = null; 
		private Vector2 m_vEntityOffset = Vector2.Empty;
		private double m_nZoomLevel = 1;
		private enumRenderType m_oRenderType = enumRenderType.Underside;
	    private double m_nPercentTransparent = 0;
		private System.Drawing.Color m_oBaseDrawColor = System.Drawing.Color.White;
		private enumEditorObject m_nEditorDisplay = enumEditorObject.Chassis;
		private enumGameScreen m_nInGameScreen = enumGameScreen.InSpace;
		#endregion

        public RenderSettings(RenderSettings oSettingsToCopyFrom)
        {
            m_oAreaToDrawAt         = oSettingsToCopyFrom.AreaToDrawAt;
            m_oEntityToCenterOn     = oSettingsToCopyFrom.EntityToCenterOn;
            m_vEntityOffset         = oSettingsToCopyFrom.EntityOffset;
            m_nZoomLevel            = oSettingsToCopyFrom.ZoomLevel;
            m_oRenderType           = oSettingsToCopyFrom.RenderType;
            m_nPercentTransparent   = oSettingsToCopyFrom.PercentTransparent;
            m_oBaseDrawColor        = oSettingsToCopyFrom.BaseDrawColor;
            m_nEditorDisplay        = oSettingsToCopyFrom.EditorDisplay;
            m_nInGameScreen         = oSettingsToCopyFrom.InGameScreen;
        }
		public RenderSettings( System.Drawing.Rectangle oAreaToDrawAt, Entity oEntityToCenterOn, 
							   Vector2 vEntityOffset, double nZoomLevel, enumRenderType oRenderType,
							   enumEditorObject oEditorDisplay, enumGameScreen oInGameScreen,
							   double nPercentTransparent, System.Drawing.Color oBaseDrawColor )
		{
			m_oAreaToDrawAt = oAreaToDrawAt;
			m_oEntityToCenterOn = oEntityToCenterOn; 
			m_vEntityOffset = vEntityOffset;
			m_nZoomLevel = nZoomLevel;
			m_oRenderType = oRenderType;
			m_nPercentTransparent = nPercentTransparent;
			m_oBaseDrawColor = oBaseDrawColor;
			m_nEditorDisplay = oEditorDisplay;
			m_nInGameScreen = oInGameScreen;
		}


		#region Properties
		public System.Drawing.Rectangle AreaToDrawAt
		{
			get
			{
				return( m_oAreaToDrawAt );
			}
			set
			{
				m_oAreaToDrawAt = value;
			}
		}
		public Entity EntityToCenterOn
		{
			get
			{
				return( m_oEntityToCenterOn );
			}
			set
			{
				m_oEntityToCenterOn = value;
			}
		}
		public Vector2 EntityOffset
		{
			get
			{
				return( m_vEntityOffset );
			}
			set
			{
				m_vEntityOffset = value;
			}
		}
		public double ZoomLevel
		{
			get
			{
				return( m_nZoomLevel );
			}
			set
			{
				m_nZoomLevel = value;
			}
		}
		public enumRenderType RenderType
		{
			get
			{
				return( m_oRenderType );
			}
			set
			{
				m_oRenderType = value;
			}
		}
		public double PercentTransparent
		{
			get
			{
				return( m_nPercentTransparent );
			}
			set
			{
				m_nPercentTransparent = value;
			}
		}
		public System.Drawing.Color BaseDrawColor
		{
			get
			{
				return( m_oBaseDrawColor );
			}
			set
			{
				m_oBaseDrawColor = value;
			}
		}
		public enumEditorObject EditorDisplay
		{
			get
			{
				return( m_nEditorDisplay );
			}
			set
			{
				m_nEditorDisplay = value;
			}
		}
		public enumGameScreen InGameScreen
		{
			get
			{
				return( m_nInGameScreen );
			}
			set
			{
				m_nInGameScreen = value;
			}
		}
		#endregion
	}
	public class CollisionInstance
	{
		#region Properties
		private Entity m_oEntity1 = null;
		private Entity m_oEntity2 = null;
		private double m_nAppTimeOfCollision = 0;
		#endregion

		public CollisionInstance( Entity oEntity1,Entity oEntity2,double nCurrentAppTime )
		{
			m_oEntity1 = oEntity1;
			m_oEntity2 = oEntity2;
			m_nAppTimeOfCollision = nCurrentAppTime;
		}


		#region Properties
		public Entity Entity1
		{
			get
			{
				return( m_oEntity1 );
			}
			set
			{
				m_oEntity1 = value;
			}
		}
		public Entity Entity2
		{
			get
			{
				return( m_oEntity2 );
			}
			set
			{
				m_oEntity2 = value;
			}
		}
		public double AppTimeOfCollision
		{
			get
			{
				return( m_nAppTimeOfCollision );
			}
			set
			{
				m_nAppTimeOfCollision = value;
			}
		}
		#endregion
	}
	public class RollingText : Location
	{
		#region Properties
		private string m_sText = "";
		private double m_nAppTimeTextStarted = 0;
		private System.Drawing.Color m_oColor = System.Drawing.Color.White;
		#endregion

		#region Properties
		public string Text
		{
			get
			{
				return( m_sText );
			}
			set
			{
				m_sText = value;
			}
		}
		public double AppTimeTextStarted
		{
			get
			{
				return( m_nAppTimeTextStarted );
			}
			set
			{
				m_nAppTimeTextStarted = value;
			}
		}
		public System.Drawing.Color Color
		{
			get
			{
				return( m_oColor );
			}
			set
			{
				m_oColor = value;
			}
		}
		#endregion
	}
	public class RedChassis
	{
		public double m_nTimeRed = 0;
		public double m_nTimeRedStarted = 0;
		public Chassis m_oChassis = null;
    }
    /*public class EntitysByZone
    {
        #region Member Variables
        private System.Collections.Generic.SortedList<int, System.Collections.Generic.SortedList<string, Entity>> m_oEntityByZone = new System.Collections.Generic.SortedList<int, System.Collections.Generic.SortedList<string, Entity>>();
        #endregion

        public Entity GetEntity(int nZoneID, string sPKey)
        {
            Entity oEntity = null;
            System.Collections.Generic.SortedList<string, Entity> oZoneEntitys = null;


            if (m_oEntityByZone.ContainsKey(nZoneID) == true)
            {
                oZoneEntitys = m_oEntityByZone[nZoneID];

                if (oZoneEntitys.ContainsKey(sPKey) == true)
                {
                    oEntity = oZoneEntitys[sPKey];
                }
            }

            return (oEntity);
        }
        public System.Collections.Generic.SortedList<string, Entity> GetEntitysInZone( int nZoneID )
        {
            System.Collections.Generic.SortedList<string, Entity> oEntitysInZone = null;

            if (m_oEntityByZone.ContainsKey(nZoneID) == true)
            {
                oEntitysInZone = m_oEntityByZone[nZoneID];
            }
            else
            {
                oEntitysInZone = new System.Collections.Generic.SortedList<string, Entity>();
            }

            return (oEntitysInZone);
        }
        public System.Collections.Generic.SortedList<string, Entity> GetCopyOfEntitysInZone(int nZoneID)
        {
            System.Collections.Generic.SortedList<string, Entity> oSourceEntitys = null;
            System.Collections.Generic.SortedList<string, Entity> oCopyOfSourceEntitys = new System.Collections.Generic.SortedList<string, Entity>();

            oSourceEntitys = GetEntitysInZone(nZoneID);
            for( int i=0 ; i<oSourceEntitys.Count ; i++ )
            {
                oCopyOfSourceEntitys.Add( oSourceEntitys.Values[i].PKey,oSourceEntitys.Values[i] );
            }

            return (oCopyOfSourceEntitys);
        }
        public int GetTotalEntityCount()
        {
            System.Collections.Generic.SortedList<string, Entity> oEntitysZone = null;
            int nCount = 0;


            for (int i = 0; i < m_oEntityByZone.Count; i++)
            {
                oEntitysZone = m_oEntityByZone.Values[i];
                nCount += oEntitysZone.Count;
            }


            return (nCount);
        }

        public void Add(int nZoneID, string sPKey, Entity oEntityToAdd)
        {
            System.Collections.Generic.SortedList<string, Entity> oZoneEntitys = null;


            if( m_oEntityByZone.ContainsKey( nZoneID ) == true )
            {
                oZoneEntitys = m_oEntityByZone[nZoneID];
            }
            else
            {
                oZoneEntitys = new System.Collections.Generic.SortedList<string, Entity>();
                m_oEntityByZone.Add(nZoneID, oZoneEntitys);
            }

            oZoneEntitys.Add(sPKey, oEntityToAdd);            
        }
        public bool Remove(int nZoneID, string sPKey)
        {
            bool bRemoved = false;
            System.Collections.Generic.SortedList<string, Entity> oZoneEntitys = null;


            if (m_oEntityByZone.ContainsKey(nZoneID) == true)
            {
                oZoneEntitys = m_oEntityByZone[nZoneID];
                oZoneEntitys.Remove(sPKey);
                bRemoved = true;
            }


            return( bRemoved );
        }
    }*/
    #endregion
}